/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.generator.openapi.SpringBootProjectSourceCodeGenerator;
import org.apache.camel.maven.generator.openapi.AbstractGenerateMojo;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateMojo
extends AbstractGenerateMojo {
    @Parameter
    private String className;
    @Parameter
    private String indent;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/restdsl-openapi", required=true)
    private String outputDirectory;
    @Parameter
    private String packageName;
    @Parameter(defaultValue="/**", required=true)
    private String[] requestMappingValues;

    public void execute() throws MojoExecutionException {
        OasDocument openapi;
        if (this.skip) {
            return;
        }
        try {
            openapi = this.readOpenApiDoc(this.specificationUri);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("can't load open api doc from " + this.specificationUri, e1);
        }
        if (openapi == null) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri + ", make sure that the specification is available at the given URI");
        }
        RestDslSourceCodeGenerator generator = RestDslGenerator.toPath((OasDocument)openapi);
        if (ObjectHelper.isNotEmpty((String)this.filterOperation)) {
            generator.withOperationFilter(this.filterOperation);
        }
        if (ObjectHelper.isNotEmpty((String)this.className)) {
            generator.withClassName(this.className);
        }
        if (this.indent != null) {
            generator.withIndent(this.indent.replace("\\t", "\t"));
        }
        if (ObjectHelper.isNotEmpty((String)this.packageName)) {
            generator.withPackageName(this.packageName);
        }
        if (ObjectHelper.isNotEmpty((String)this.destinationGenerator)) {
            DestinationGenerator destinationGeneratorObject = this.createDestinationGenerator();
            generator.withDestinationGenerator(destinationGeneratorObject);
        } else if (ObjectHelper.isNotEmpty((String)this.destinationToSyntax)) {
            generator.withDestinationToSyntax(this.destinationToSyntax);
        }
        Path outputPath = new File(this.outputDirectory).toPath();
        if (this.restConfiguration) {
            String comp = this.findAppropriateComponent();
            generator.withRestComponent(comp);
            if (this.clientRequestValidation) {
                generator.withClientRequestValidation();
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                generator.withApiContextPath(this.apiContextPath);
            }
            if (this.detectSpringBootFromClasspath() && "servlet".equals(comp)) {
                try {
                    String pName;
                    if (ObjectHelper.isEmpty((String)this.packageName) && (pName = this.detectSpringBootMainPackage()) != null) {
                        this.packageName = pName;
                        generator.withPackageName(this.packageName);
                        this.getLog().info((CharSequence)("Detected @SpringBootApplication, and will be using its package name: " + this.packageName));
                    }
                    this.getLog().info((CharSequence)("Generating Camel Rest Controller source with package name " + this.packageName + " in source directory: " + outputPath));
                    SpringBootProjectSourceCodeGenerator.generator().withPackageName(this.packageName).withMappingValues(this.requestMappingValues).generate(outputPath);
                    generator.withRestContextPath("/");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to generate Camel Rest Controller source due " + e.getMessage(), (Exception)e);
                }
            }
        }
        if (this.detectSpringBootFromClasspath()) {
            generator.asSpringComponent();
            generator.asSpringBootProject();
        }
        try {
            this.getLog().info((CharSequence)("Generating Camel DSL source in directory: " + outputPath));
            generator.generate((Object)outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri, (Exception)e);
        }
        if (ObjectHelper.isNotEmpty((String)this.modelOutput)) {
            this.project.addCompileSourceRoot(this.modelOutput);
        }
        if (ObjectHelper.isNotEmpty((String)this.outputDirectory)) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }
}

