/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.maven.generator.openapi.AbstractGenerateMojo;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-xml", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateXmlMojo
extends AbstractGenerateMojo {
    @Parameter(defaultValue="false")
    private boolean blueprint;
    @Parameter(defaultValue="camel-rest.xml", required=true)
    private String fileName;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/restdsl-openapi", required=true)
    private String outputDirectory;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        OasDocument openapi = null;
        try {
            openapi = this.readOpenApiDoc(this.specificationUri);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("can't load open api doc from " + this.specificationUri, e1);
        }
        if (openapi == null) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri + ", make sure that the specification is available at the given URI");
        }
        RestDslXmlGenerator generator = RestDslGenerator.toXml((OasDocument)openapi);
        if (this.blueprint) {
            generator.withBlueprint();
        }
        if (ObjectHelper.isNotEmpty((String)this.basePath)) {
            generator.withBasePath(this.basePath);
        }
        if (ObjectHelper.isNotEmpty((String)this.filterOperation)) {
            generator.withOperationFilter(this.filterOperation);
        }
        if (ObjectHelper.isNotEmpty((String)this.destinationGenerator)) {
            DestinationGenerator destinationGeneratorObject = this.createDestinationGenerator();
            generator.withDestinationGenerator(destinationGeneratorObject);
        } else if (ObjectHelper.isNotEmpty((String)this.destinationToSyntax)) {
            generator.withDestinationToSyntax(this.destinationToSyntax);
        }
        if (this.restConfiguration) {
            generator.withRestComponent(this.findAppropriateComponent());
            if (this.clientRequestValidation) {
                generator.withClientRequestValidation();
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                generator.withApiContextPath(this.apiContextPath);
            }
        }
        try {
            DefaultCamelContext camel = new DefaultCamelContext();
            String xml = generator.generate((CamelContext)camel);
            new File(this.outputDirectory).mkdirs();
            File out = new File(this.outputDirectory, this.fileName);
            try (FileOutputStream fos = new FileOutputStream(out);){
                fos.write(xml.getBytes());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri, e);
        }
    }
}

