/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.generator.openapi;

import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.generator.openapi.SpringBootProjectSourceCodeGenerator;
import org.apache.camel.maven.generator.openapi.AbstractGenerateMojo;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateMojo
extends AbstractGenerateMojo {
    @Parameter
    private String className;
    @Parameter
    private String indent;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/restdsl-openapi", required=true)
    private String outputDirectory;
    @Parameter
    private String packageName;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        OasDocument openapi = null;
        try {
            openapi = this.readOpenApiDoc(this.specificationUri);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("can't load open api doc from " + this.specificationUri, e1);
        }
        if (openapi == null) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri + ", make sure that the specification is available at the given URI");
        }
        RestDslSourceCodeGenerator generator = RestDslGenerator.toPath((OasDocument)openapi);
        if (ObjectHelper.isNotEmpty((Object)this.filterOperation)) {
            generator.withOperationFilter(this.filterOperation);
        }
        if (ObjectHelper.isNotEmpty((Object)this.className)) {
            generator.withClassName(this.className);
        }
        if (this.indent != null) {
            generator.withIndent(this.indent.replace("\\t", "\t"));
        }
        if (ObjectHelper.isNotEmpty((Object)this.packageName)) {
            generator.withPackageName(this.packageName);
        }
        if (ObjectHelper.isNotEmpty((Object)this.destinationGenerator)) {
            DestinationGenerator destinationGeneratorObject = this.createDestinationGenerator();
            generator.withDestinationGenerator(destinationGeneratorObject);
        }
        Path outputPath = new File(this.outputDirectory).toPath();
        if (this.restConfiguration) {
            String comp = this.detectRestComponentFromClasspath();
            if (comp != null) {
                this.getLog().info((CharSequence)("Detected Camel Rest component from classpath: " + comp));
                generator.withRestComponent(comp);
            } else {
                comp = "servlet";
                String aid = "camel-servlet";
                if (this.detectSpringBootFromClasspath()) {
                    aid = "camel-servlet-starter";
                }
                String dep = "\n\t\t<dependency>\n\t\t\t<groupId>org.apache.camel</groupId>\n\t\t\t<artifactId>" + aid + "</artifactId>";
                String ver = this.detectCamelVersionFromClasspath();
                if (ver != null) {
                    dep = dep + "\n\t\t\t<version>" + ver + "</version>";
                }
                dep = dep + "\n\t\t</dependency>\n";
                this.getLog().info((CharSequence)"Cannot detect Rest component from classpath. Will use servlet as Rest component.");
                this.getLog().info((CharSequence)("Add the following dependency in the Maven pom.xml file:\n" + dep + "\n"));
                generator.withRestComponent("servlet");
            }
            if (ObjectHelper.isNotEmpty((Object)this.apiContextPath)) {
                generator.withApiContextPath(this.apiContextPath);
            }
            if (this.detectSpringBootFromClasspath() && "servlet".equals(comp)) {
                try {
                    String pName;
                    if (ObjectHelper.isEmpty((Object)this.packageName) && (pName = this.detectSpringBootMainPackage()) != null) {
                        this.packageName = pName;
                        generator.withPackageName(this.packageName);
                        this.getLog().info((CharSequence)("Detected @SpringBootApplication, and will be using its package name: " + this.packageName));
                    }
                    this.getLog().info((CharSequence)("Generating Camel Rest Controller source with package name " + this.packageName + " in source directory: " + outputPath));
                    SpringBootProjectSourceCodeGenerator.generator().withPackageName(this.packageName).generate(outputPath);
                    generator.withRestContextPath("/");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to generate Camel Rest Controller source due " + e.getMessage(), (Exception)e);
                }
            }
        }
        if (this.detectSpringBootFromClasspath()) {
            generator.asSpringComponent();
            generator.asSpringBootProject();
        }
        try {
            this.getLog().info((CharSequence)("Generating Camel DSL source in directory: " + outputPath));
            generator.generate((Object)outputPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate REST DSL OpenApi sources from specification: " + this.specificationUri, (Exception)e);
        }
    }
}

