/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class RestOpenApiProducer
extends DelegateAsyncProcessor
implements AsyncProducer {
    private final AsyncProducer delegate;
    private final boolean removeHostHeader;

    public RestOpenApiProducer(AsyncProducer delegate, boolean removeHostHeader) {
        super((AsyncProcessor)delegate);
        this.delegate = delegate;
        this.removeHostHeader = removeHostHeader;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.removeHostHeader) {
            exchange.getMessage().removeHeader("Host");
        }
        return super.process(exchange, callback);
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        if (this.removeHostHeader) {
            exchange.getMessage().removeHeader("Host");
        }
        return super.processAsync(exchange);
    }

    public Endpoint getEndpoint() {
        return this.delegate.getEndpoint();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }
}

