/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;

public class CamelJob
implements Job,
Serializable {
    private static final long serialVersionUID = 26L;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext;
        String camelContextName = (String)context.getJobDetail().getJobDataMap().get((Object)"CamelQuartzCamelContextName");
        String endpointUri = (String)context.getJobDetail().getJobDataMap().get((Object)"CamelQuartzEndpoint");
        try {
            schedulerContext = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + context.getJobDetail().getName());
        }
        CamelContext camelContext = (CamelContext)schedulerContext.get((Object)("CamelQuartzCamelContext-" + camelContextName));
        if (camelContext == null) {
            throw new JobExecutionException("No CamelContext could be found with name: " + camelContextName);
        }
        QuartzEndpoint endpoint = (QuartzEndpoint)camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
        if (endpoint == null) {
            throw new JobExecutionException("No QuartzEndpoint could be found with uri: " + endpointUri);
        }
        endpoint.onJobExecute(context);
    }
}

