/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.io.Serializable;
import org.apache.camel.Route;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;

public class ScheduledJob
implements Job,
Serializable,
ScheduledRoutePolicyConstants {
    private static final long serialVersionUID = 26L;
    private Route storedRoute;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SchedulerContext schedulerContext;
        try {
            schedulerContext = jobExecutionContext.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + jobExecutionContext.getJobDetail().getName());
        }
        ScheduledRoutePolicyConstants.Action storedAction = (ScheduledRoutePolicyConstants.Action)((Object)schedulerContext.get((Object)"ScheduledAction"));
        this.storedRoute = (Route)schedulerContext.get((Object)"ScheduledRoute");
        ScheduledRoutePolicy policy = (ScheduledRoutePolicy)this.storedRoute.getRouteContext().getRoutePolicy();
        try {
            policy.onJobExecute(storedAction, this.storedRoute);
        }
        catch (Exception e) {
            throw new JobExecutionException("Failed to execute Scheduled Job for route " + this.storedRoute.getId() + " with trigger name: " + jobExecutionContext.getTrigger().getFullName());
        }
    }
}

