/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelJob
implements Job,
Serializable {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelJob.class);
    private static final long serialVersionUID = 27L;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext;
        String camelContextName = (String)context.getJobDetail().getJobDataMap().get((Object)"CamelQuartzCamelContextName");
        String endpointUri = (String)context.getJobDetail().getJobDataMap().get((Object)"CamelQuartzEndpoint");
        try {
            schedulerContext = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to obtain scheduler context for job " + context.getJobDetail().getName());
        }
        CamelContext camelContext = (CamelContext)schedulerContext.get((Object)("CamelQuartzCamelContext-" + camelContextName));
        if (camelContext == null) {
            throw new JobExecutionException("No CamelContext could be found with name: " + camelContextName);
        }
        Trigger trigger = context.getTrigger();
        QuartzEndpoint endpoint = this.lookupQuartzEndpoint(camelContext, endpointUri, trigger);
        if (endpoint == null) {
            throw new JobExecutionException("No QuartzEndpoint could be found with endpointUri: " + endpointUri);
        }
        endpoint.onJobExecute(context);
    }

    private QuartzEndpoint lookupQuartzEndpoint(CamelContext camelContext, String endpointUri, Trigger trigger) throws JobExecutionException {
        String targetTriggerName = trigger.getName();
        String targetTriggerGroup = trigger.getGroup();
        LOG.debug("Looking up existing QuartzEndpoint with trigger {}.{}", (Object)targetTriggerName, (Object)targetTriggerGroup);
        try {
            for (Route route : camelContext.getRoutes()) {
                if (!(route.getEndpoint() instanceof QuartzEndpoint)) continue;
                QuartzEndpoint quartzEndpoint = (QuartzEndpoint)route.getEndpoint();
                String triggerName = quartzEndpoint.getTrigger().getName();
                String triggerGroup = quartzEndpoint.getTrigger().getGroup();
                LOG.trace("Checking route trigger {}.{}", (Object)triggerName, (Object)triggerGroup);
                if (!triggerName.equals(targetTriggerName) || !triggerGroup.equals(targetTriggerGroup)) continue;
                return (QuartzEndpoint)route.getEndpoint();
            }
        }
        catch (Exception e) {
            throw new JobExecutionException("Error lookup up existing QuartzEndpoint with trigger: " + trigger, (Throwable)e);
        }
        if (camelContext.hasEndpoint(endpointUri) != null) {
            return (QuartzEndpoint)camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
        }
        LOG.warn("Cannot find existing QuartzEndpoint with uri: {}. Creating new endpoint instance.", (Object)endpointUri);
        return (QuartzEndpoint)camelContext.getEndpoint(endpointUri, QuartzEndpoint.class);
    }
}

