/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(QuartzComponent.class);
    private SchedulerFactory factory;
    private Scheduler scheduler;
    private Map<Trigger, JobDetail> triggers;

    public QuartzComponent() {
    }

    public QuartzComponent(CamelContext context) {
        super(context);
    }

    protected QuartzEndpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        String name;
        String group;
        QuartzEndpoint answer = new QuartzEndpoint(uri, this, this.getScheduler());
        URI u = new URI(uri);
        String path = ObjectHelper.after((String)u.getPath(), (String)"/");
        String host = u.getHost();
        String cron = (String)this.getAndRemoveParameter(parameters, "cron", String.class);
        if (ObjectHelper.isNotEmpty((Object)path) && ObjectHelper.isNotEmpty((Object)host)) {
            group = host;
            name = path;
        } else {
            group = "Camel";
            name = host;
        }
        Object trigger = ObjectHelper.isNotEmpty((Object)cron) ? this.createCronTrigger(cron) : new SimpleTrigger();
        answer.setTrigger((Trigger)trigger);
        trigger.setName(name);
        trigger.setGroup(group);
        Map triggerParameters = IntrospectionSupport.extractProperties((Map)parameters, (String)"trigger.");
        Map jobParameters = IntrospectionSupport.extractProperties((Map)parameters, (String)"job.");
        this.setProperties(trigger, triggerParameters);
        this.setProperties(answer.getJobDetail(), jobParameters);
        return answer;
    }

    protected CronTrigger createCronTrigger(String path) throws ParseException {
        path = path.replaceAll("\\+", " ");
        CronTrigger cron = new CronTrigger();
        cron.setCronExpression(path);
        return cron;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler == null) {
            this.scheduler = this.getScheduler();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Quartz scheduler: " + this.scheduler.getSchedulerName()));
        }
        this.scheduler.start();
    }

    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Shutting down Quartz scheduler: " + this.scheduler.getSchedulerName()));
            }
            this.scheduler.shutdown();
        }
        super.doStop();
    }

    public SchedulerFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.createSchedulerFactory();
        }
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map<Trigger, JobDetail> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Map<Trigger, JobDetail> triggers) {
        this.triggers = triggers;
    }

    protected SchedulerFactory createSchedulerFactory() {
        return new StdSchedulerFactory();
    }

    protected Scheduler createScheduler() throws SchedulerException {
        Scheduler scheduler = this.getFactory().getScheduler();
        scheduler.getContext().put((Object)"CamelQuartzCamelContext", (Object)this.getCamelContext());
        return scheduler;
    }
}

