/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant.transform;

import io.qdrant.client.ValueFactory;
import io.qdrant.client.grpc.JsonWithInt;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="qdrant:rag", description="Prepares the similarity search LangChain4j embeddings to become a List of String for LangChain4j RAG")
public class QdrantReverseEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType from, DataType to) throws Exception {
        List embeddings = (List)message.getBody(List.class);
        List result = embeddings.stream().map(embedding -> embedding.getPayloadMap()).map(payloadMap -> payloadMap.getOrDefault("text_segment", ValueFactory.value((String)""))).map(JsonWithInt.Value::getStringValue).collect(Collectors.toList());
        message.setBody(result);
    }
}

