/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant;

import io.qdrant.client.grpc.Points;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.qdrant.QdrantConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class QdrantConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        QdrantConverterLoader.addTypeConverter(registry, Points.PointId.class, Long.class, false, (type, exchange, value) -> {
            Points.PointId answer = QdrantConverter.toPointId((Long)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, Points.PointId.class, UUID.class, false, (type, exchange, value) -> {
            Points.PointId answer = QdrantConverter.toPointId((UUID)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, Points.PointId.class, Long.TYPE, false, (type, exchange, value) -> {
            Points.PointId answer = QdrantConverter.toPointId((long)((Long)value));
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, Points.PointsSelector.class, Points.Condition.class, false, (type, exchange, value) -> {
            Points.PointsSelector answer = QdrantConverter.toPointSelector((Points.Condition)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, Points.PointsSelector.class, Points.Filter.class, false, (type, exchange, value) -> {
            Points.PointsSelector answer = QdrantConverter.toPointSelector((Points.Filter)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, Points.PointsSelector.class, Points.PointId.class, false, (type, exchange, value) -> {
            Points.PointsSelector answer = QdrantConverter.toPointSelector((Points.PointId)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, List.class, Points.PointId.class, false, (type, exchange, value) -> {
            List<Points.PointId> answer = QdrantConverter.toListOfPointIds((Points.PointId)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, List.class, Points.PointStruct.class, false, (type, exchange, value) -> {
            List<Points.PointStruct> answer = QdrantConverter.toListOfPointStructs((Points.PointStruct)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, List.class, Collection.class, false, (type, exchange, value) -> {
            List<Points.PointId> answer = QdrantConverter.toListOfPointIdsFromCollection((Collection)value);
            return answer;
        });
        QdrantConverterLoader.addTypeConverter(registry, List.class, Collection.class, false, (type, exchange, value) -> {
            List<Points.PointStruct> answer = QdrantConverter.toListOfPointStructsFromCollection((Collection)value);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

