/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.python;

import org.apache.camel.Exchange;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.support.ExpressionSupport;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PythonExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;

    public PythonExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
    }

    public static PythonExpression python(String expression) {
        return new PythonExpression(expression, Object.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try (PythonInterpreter compiler = new PythonInterpreter();){
            compiler.set("exchange", (Object)exchange);
            compiler.set("context", (Object)exchange.getContext());
            compiler.set("exchangeId", (Object)exchange.getExchangeId());
            compiler.set("message", (Object)exchange.getMessage());
            compiler.set("headers", (Object)exchange.getMessage().getHeaders());
            compiler.set("properties", (Object)exchange.getAllProperties());
            compiler.set("body", exchange.getMessage().getBody());
            PyObject out = compiler.eval(this.expressionString);
            if (out == null) return null;
            String value = out.toString();
            Object object = exchange.getContext().getTypeConverter().convertTo(type, (Object)value);
            return (T)object;
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(this.expressionString, (Throwable)e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "Python[" + this.expressionString + "]";
    }
}

