/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

public class PulsarComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private PulsarConfiguration getOrCreateConfiguration(PulsarComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new PulsarConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                this.getOrCreateConfiguration(target).setAckGroupTimeMillis((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                this.getOrCreateConfiguration(target).setAckTimeoutMillis((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                this.getOrCreateConfiguration(target).setAllowManualAcknowledgement((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                target.setAutoConfiguration((AutoConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, AutoConfiguration.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                this.getOrCreateConfiguration(target).setBatcherBuilder((BatcherBuilder)PulsarComponentConfigurer.property((CamelContext)camelContext, BatcherBuilder.class, (Object)value));
                return true;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                this.getOrCreateConfiguration(target).setBatchingEnabled((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                this.getOrCreateConfiguration(target).setBatchingMaxMessages((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                this.getOrCreateConfiguration(target).setBatchingMaxPublishDelayMicros((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                this.getOrCreateConfiguration(target).setBlockIfQueueFull((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                this.getOrCreateConfiguration(target).setCompressionType((CompressionType)PulsarComponentConfigurer.property((CamelContext)camelContext, CompressionType.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((PulsarConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarConfiguration.class, (Object)value));
                return true;
            }
            case "consumername": 
            case "consumerName": {
                this.getOrCreateConfiguration(target).setConsumerName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                this.getOrCreateConfiguration(target).setConsumerNamePrefix((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                this.getOrCreateConfiguration(target).setConsumerQueueSize((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                this.getOrCreateConfiguration(target).setDeadLetterTopic((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                this.getOrCreateConfiguration(target).setInitialSequenceId((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                this.getOrCreateConfiguration(target).setMaxPendingMessages((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                this.getOrCreateConfiguration(target).setMaxPendingMessagesAcrossPartitions((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                this.getOrCreateConfiguration(target).setMaxRedeliverCount((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messagerouter": 
            case "messageRouter": {
                this.getOrCreateConfiguration(target).setMessageRouter((MessageRouter)PulsarComponentConfigurer.property((CamelContext)camelContext, MessageRouter.class, (Object)value));
                return true;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                this.getOrCreateConfiguration(target).setMessageRoutingMode((MessageRoutingMode)PulsarComponentConfigurer.property((CamelContext)camelContext, MessageRoutingMode.class, (Object)value));
                return true;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                this.getOrCreateConfiguration(target).setNegativeAckRedeliveryDelayMicros((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                this.getOrCreateConfiguration(target).setNumberOfConsumers((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producername": 
            case "producerName": {
                this.getOrCreateConfiguration(target).setProducerName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pulsarclient": 
            case "pulsarClient": {
                target.setPulsarClient((PulsarClient)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarClient.class, (Object)value));
                return true;
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                target.setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarMessageReceiptFactory.class, (Object)value));
                return true;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                this.getOrCreateConfiguration(target).setSendTimeoutMs((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                this.getOrCreateConfiguration(target).setSubscriptionInitialPosition((SubscriptionInitialPosition)((Object)PulsarComponentConfigurer.property((CamelContext)camelContext, SubscriptionInitialPosition.class, (Object)value)));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                this.getOrCreateConfiguration(target).setSubscriptionName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                this.getOrCreateConfiguration(target).setSubscriptionTopicsMode((RegexSubscriptionMode)PulsarComponentConfigurer.property((CamelContext)camelContext, RegexSubscriptionMode.class, (Object)value));
                return true;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                this.getOrCreateConfiguration(target).setSubscriptionType((SubscriptionType)((Object)PulsarComponentConfigurer.property((CamelContext)camelContext, SubscriptionType.class, (Object)value)));
                return true;
            }
            case "topicspattern": 
            case "topicsPattern": {
                this.getOrCreateConfiguration(target).setTopicsPattern((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return this.getOrCreateConfiguration(target).getAckGroupTimeMillis();
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return this.getOrCreateConfiguration(target).getAckTimeoutMillis();
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return this.getOrCreateConfiguration(target).isAllowManualAcknowledgement();
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                return target.getAutoConfiguration();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return this.getOrCreateConfiguration(target).getBatcherBuilder();
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return this.getOrCreateConfiguration(target).isBatchingEnabled();
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return this.getOrCreateConfiguration(target).getBatchingMaxMessages();
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return this.getOrCreateConfiguration(target).getBatchingMaxPublishDelayMicros();
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return this.getOrCreateConfiguration(target).isBlockIfQueueFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "compressiontype": 
            case "compressionType": {
                return this.getOrCreateConfiguration(target).getCompressionType();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consumername": 
            case "consumerName": {
                return this.getOrCreateConfiguration(target).getConsumerName();
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return this.getOrCreateConfiguration(target).getConsumerNamePrefix();
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return this.getOrCreateConfiguration(target).getConsumerQueueSize();
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return this.getOrCreateConfiguration(target).getDeadLetterTopic();
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return this.getOrCreateConfiguration(target).getInitialSequenceId();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessages();
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessagesAcrossPartitions();
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return this.getOrCreateConfiguration(target).getMaxRedeliverCount();
            }
            case "messagerouter": 
            case "messageRouter": {
                return this.getOrCreateConfiguration(target).getMessageRouter();
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return this.getOrCreateConfiguration(target).getMessageRoutingMode();
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return this.getOrCreateConfiguration(target).getNegativeAckRedeliveryDelayMicros();
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return this.getOrCreateConfiguration(target).getNumberOfConsumers();
            }
            case "producername": 
            case "producerName": {
                return this.getOrCreateConfiguration(target).getProducerName();
            }
            case "pulsarclient": 
            case "pulsarClient": {
                return target.getPulsarClient();
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                return target.getPulsarMessageReceiptFactory();
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return this.getOrCreateConfiguration(target).getSendTimeoutMs();
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return this.getOrCreateConfiguration(target).getSubscriptionInitialPosition();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return this.getOrCreateConfiguration(target).getSubscriptionName();
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return this.getOrCreateConfiguration(target).getSubscriptionTopicsMode();
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return this.getOrCreateConfiguration(target).getSubscriptionType();
            }
            case "topicspattern": 
            case "topicsPattern": {
                return this.getOrCreateConfiguration(target).isTopicsPattern();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("configuration", PulsarConfiguration.class);
        map.put("ackGroupTimeMillis", Long.TYPE);
        map.put("ackTimeoutMillis", Long.TYPE);
        map.put("allowManualAcknowledgement", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("consumerName", String.class);
        map.put("consumerNamePrefix", String.class);
        map.put("consumerQueueSize", Integer.TYPE);
        map.put("deadLetterTopic", String.class);
        map.put("maxRedeliverCount", Integer.class);
        map.put("negativeAckRedeliveryDelayMicros", Long.TYPE);
        map.put("numberOfConsumers", Integer.TYPE);
        map.put("subscriptionInitialPosition", SubscriptionInitialPosition.class);
        map.put("subscriptionName", String.class);
        map.put("subscriptionTopicsMode", RegexSubscriptionMode.class);
        map.put("subscriptionType", SubscriptionType.class);
        map.put("topicsPattern", Boolean.TYPE);
        map.put("pulsarMessageReceiptFactory", PulsarMessageReceiptFactory.class);
        map.put("batcherBuilder", BatcherBuilder.class);
        map.put("batchingEnabled", Boolean.TYPE);
        map.put("batchingMaxMessages", Integer.TYPE);
        map.put("batchingMaxPublishDelayMicros", Long.TYPE);
        map.put("blockIfQueueFull", Boolean.TYPE);
        map.put("compressionType", CompressionType.class);
        map.put("initialSequenceId", Long.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("maxPendingMessages", Integer.TYPE);
        map.put("maxPendingMessagesAcrossPartitions", Integer.TYPE);
        map.put("messageRouter", MessageRouter.class);
        map.put("messageRoutingMode", MessageRoutingMode.class);
        map.put("producerName", String.class);
        map.put("sendTimeoutMs", Integer.TYPE);
        map.put("autoConfiguration", AutoConfiguration.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("pulsarClient", PulsarClient.class);
        ALL_OPTIONS = map;
    }
}

