/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.concurrent.TimeUnit;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

@UriParams
public class PulsarConfiguration
implements Cloneable {
    @UriParam(label="common")
    private String serviceUrl;
    @UriParam(label="common")
    private String authenticationClass;
    @UriParam(label="common")
    private String authenticationParams;
    @UriParam(label="consumer")
    private boolean topicsPattern;
    @UriParam(label="consumer", defaultValue="PersistentOnly")
    private RegexSubscriptionMode subscriptionTopicsMode;
    @UriParam(label="consumer", defaultValue="subs")
    private String subscriptionName = "subs";
    @UriParam(label="consumer", defaultValue="EXCLUSIVE")
    private SubscriptionType subscriptionType = SubscriptionType.EXCLUSIVE;
    @UriParam(label="consumer", defaultValue="1")
    private int numberOfConsumers = 1;
    @UriParam(label="consumer", defaultValue="10")
    private int consumerQueueSize = 10;
    @UriParam(label="consumer", defaultValue="sole-consumer")
    private String consumerName = "sole-consumer";
    @UriParam(label="producer")
    private String producerName;
    @UriParam(label="consumer", defaultValue="cons")
    private String consumerNamePrefix = "cons";
    @UriParam(label="consumer", defaultValue="false")
    private boolean allowManualAcknowledgement;
    @UriParam(label="consumer", defaultValue="10000")
    private long ackTimeoutMillis = 10000L;
    @UriParam(label="consumer", defaultValue="60000000")
    private long negativeAckRedeliveryDelayMicros = 60000000L;
    @UriParam(label="consumer", description="RedeliveryBackoff to use for ack timeout redelivery backoff.")
    private RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    @UriParam(label="consumer", description="RedeliveryBackoff to use for negative ack redelivery backoff.")
    private RedeliveryBackoff negativeAckRedeliveryBackoff;
    @UriParam(label="consumer", defaultValue="100")
    private long ackGroupTimeMillis = 100L;
    @UriParam(label="consumer", defaultValue="LATEST")
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.LATEST;
    @UriParam(label="consumer", defaultValue="false")
    private boolean readCompacted;
    @UriParam(label="consumer", description="Maximum number of times that a message will be redelivered before being sent to the dead letter queue. If this value is not set, no Dead Letter Policy will be created")
    private Integer maxRedeliverCount;
    @UriParam(label="consumer", description="Name of the topic where the messages which fail maxRedeliverCount times will be sent. Note: if not set, default topic name will be topicName-subscriptionName-DLQ")
    private String deadLetterTopic;
    @UriParam(label="consumer", defaultValue="true", description="Whether to use the `messageListener` interface, or to receive messages using a separate thread pool")
    private boolean messageListener = true;
    @UriParam(label="consumer", defaultValue="1", description="Number of threads to receive and handle messages when using a separate thread pool")
    private int numberOfConsumerThreads = 1;
    @UriParam(label="producer", description="Send timeout in milliseconds", defaultValue="30000")
    private int sendTimeoutMs = 30000;
    @UriParam(label="producer", description="Whether to block the producing thread if pending messages queue is full or to throw a ProducerQueueIsFullError", defaultValue="false")
    private boolean blockIfQueueFull;
    @UriParam(label="producer", description="Size of the pending massages queue. When the queue is full, by default, any further sends will fail unless blockIfQueueFull=true", defaultValue="1000")
    private int maxPendingMessages = 1000;
    @UriParam(label="producer", description="The maximum number of pending messages for partitioned topics. The maxPendingMessages value will be reduced if (number of partitions * maxPendingMessages) exceeds this value. Partitioned topics have a pending message queue for each partition.", defaultValue="50000")
    @Deprecated
    private int maxPendingMessagesAcrossPartitions = 50000;
    @UriParam(label="producer", description="The maximum time period within which the messages sent will be batched if batchingEnabled is true.", defaultValue="1000")
    private long batchingMaxPublishDelayMicros = TimeUnit.MILLISECONDS.toMicros(1L);
    @UriParam(label="producer", description="The maximum size to batch messages.", defaultValue="1000")
    private int batchingMaxMessages = 1000;
    @UriParam(label="producer", description="Control whether automatic batching of messages is enabled for the producer.", defaultValue="true")
    private boolean batchingEnabled = true;
    @UriParam(label="producer", description="Control batching method used by the producer.", defaultValue="DEFAULT")
    private BatcherBuilder batcherBuilder = BatcherBuilder.DEFAULT;
    @UriParam(label="producer", description="The first message published will have a sequence Id of initialSequenceId  1.", defaultValue="-1")
    private long initialSequenceId = -1L;
    @UriParam(label="producer", description="Compression type to use", defaultValue="NONE")
    private CompressionType compressionType = CompressionType.NONE;
    @UriParam(label="producer", description="Message Routing Mode to use", defaultValue="RoundRobinPartition")
    private MessageRoutingMode messageRoutingMode = MessageRoutingMode.RoundRobinPartition;
    @UriParam(label="producer", description="Custom Message Router to use")
    private MessageRouter messageRouter;

    public PulsarConfiguration copy() {
        try {
            PulsarConfiguration copy = (PulsarConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public boolean isTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(boolean topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public RegexSubscriptionMode getSubscriptionTopicsMode() {
        return this.subscriptionTopicsMode;
    }

    public void setSubscriptionTopicsMode(RegexSubscriptionMode subscriptionTopicsMode) {
        this.subscriptionTopicsMode = subscriptionTopicsMode;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConsumers;
    }

    public void setNumberOfConsumers(int numberOfConsumers) {
        this.numberOfConsumers = numberOfConsumers;
    }

    public int getConsumerQueueSize() {
        return this.consumerQueueSize;
    }

    public void setConsumerQueueSize(int consumerQueueSize) {
        this.consumerQueueSize = consumerQueueSize;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getConsumerNamePrefix() {
        return this.consumerNamePrefix;
    }

    public void setConsumerNamePrefix(String consumerNamePrefix) {
        this.consumerNamePrefix = consumerNamePrefix;
    }

    public boolean isAllowManualAcknowledgement() {
        return this.allowManualAcknowledgement;
    }

    public void setAllowManualAcknowledgement(boolean allowManualAcknowledgement) {
        this.allowManualAcknowledgement = allowManualAcknowledgement;
    }

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public void setAckTimeoutMillis(long ackTimeoutMillis) {
        this.ackTimeoutMillis = ackTimeoutMillis;
    }

    public long getAckGroupTimeMillis() {
        return this.ackGroupTimeMillis;
    }

    public void setAckGroupTimeMillis(long ackGroupTimeMillis) {
        this.ackGroupTimeMillis = ackGroupTimeMillis;
    }

    public void setSendTimeoutMs(int sendTimeoutMs) {
        this.sendTimeoutMs = sendTimeoutMs;
    }

    public int getSendTimeoutMs() {
        return this.sendTimeoutMs;
    }

    public void setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public boolean isBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public void setMaxPendingMessages(int maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public int getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    @Deprecated
    public void setMaxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    @Deprecated
    public int getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public void setBatchingMaxPublishDelayMicros(long batchingMaxPublishDelayMicros) {
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
    }

    public long getBatchingMaxPublishDelayMicros() {
        return this.batchingMaxPublishDelayMicros;
    }

    public void setBatchingMaxMessages(int batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public int getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatcherBuilder(BatcherBuilder batcherBuilder) {
        this.batcherBuilder = batcherBuilder;
    }

    public BatcherBuilder getBatcherBuilder() {
        return this.batcherBuilder;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public void setInitialSequenceId(long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    public long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = CompressionType.valueOf((String)compressionType.toUpperCase());
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public MessageRoutingMode getMessageRoutingMode() {
        return this.messageRoutingMode;
    }

    public void setMessageRoutingMode(MessageRoutingMode messageRoutingMode) {
        this.messageRoutingMode = messageRoutingMode;
    }

    public MessageRouter getMessageRouter() {
        return this.messageRouter;
    }

    public void setMessageRouter(MessageRouter messageRouter) {
        this.messageRouter = messageRouter;
    }

    public long getNegativeAckRedeliveryDelayMicros() {
        return this.negativeAckRedeliveryDelayMicros;
    }

    public void setNegativeAckRedeliveryDelayMicros(long negativeAckRedeliveryDelayMicros) {
        this.negativeAckRedeliveryDelayMicros = negativeAckRedeliveryDelayMicros;
    }

    public RedeliveryBackoff getAckTimeoutRedeliveryBackoff() {
        return this.ackTimeoutRedeliveryBackoff;
    }

    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff redeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = redeliveryBackoff;
    }

    public RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff redeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = redeliveryBackoff;
    }

    public Integer getMaxRedeliverCount() {
        return this.maxRedeliverCount;
    }

    public void setMaxRedeliverCount(Integer maxRedeliverCount) {
        this.maxRedeliverCount = maxRedeliverCount;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public boolean isMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(boolean messageListener) {
        this.messageListener = messageListener;
    }

    public int getNumberOfConsumerThreads() {
        return this.numberOfConsumerThreads;
    }

    public void setNumberOfConsumerThreads(int numberOfConsumerThreads) {
        this.numberOfConsumerThreads = numberOfConsumerThreads;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getAuthenticationClass() {
        return this.authenticationClass;
    }

    public void setAuthenticationClass(String authenticationClass) {
        this.authenticationClass = authenticationClass;
    }

    public String getAuthenticationParams() {
        return this.authenticationParams;
    }

    public void setAuthenticationParams(String authenticationParams) {
        this.authenticationParams = authenticationParams;
    }
}

