/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;

public final class PulsarMessageUtils {
    private PulsarMessageUtils() {
    }

    public static Exchange updateExchange(org.apache.pulsar.client.api.Message<byte[]> message, Exchange input) {
        Exchange output = input.copy();
        Message msg = output.getIn();
        msg.setHeader("event_time", (Object)message.getEventTime());
        msg.setHeader("message_id", (Object)message.getMessageId());
        msg.setHeader("key", (Object)message.getKey());
        msg.setHeader("key_bytes", (Object)message.getKeyBytes());
        msg.setHeader("producer_name", (Object)message.getProducerName());
        msg.setHeader("topic_name", (Object)message.getTopicName());
        msg.setHeader("sequence_id", (Object)message.getSequenceId());
        msg.setHeader("publish_time", (Object)message.getPublishTime());
        msg.setHeader("properties", (Object)message.getProperties());
        msg.setHeader("CamelMessageTimestamp", (Object)message.getPublishTime());
        msg.setBody(message.getValue());
        output.setIn(msg);
        return output;
    }

    public static Exchange updateExchangeWithException(Exception exception, Exchange input) {
        Exchange output = input.copy();
        output.setException((Throwable)exception);
        return output;
    }

    public static byte[] serialize(Object body) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            outputStream.writeObject(body);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (NotSerializableException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
        finally {
            byteArrayOutputStream.close();
            outputStream.close();
        }
    }
}

