/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.CamelContext;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.pulsar.client.api.PulsarClient;

public class PulsarComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object component, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return PulsarComponentConfigurer.doConfigureIgnoreCase(camelContext, component, name, value);
        }
        return PulsarComponentConfigurer.doConfigure(camelContext, component, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object component, String name, Object value) {
        switch (name) {
            case "autoConfiguration": {
                ((PulsarComponent)((Object)component)).setAutoConfiguration((AutoConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, AutoConfiguration.class, (Object)value));
                return true;
            }
            case "pulsarClient": {
                ((PulsarComponent)((Object)component)).setPulsarClient((PulsarClient)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarClient.class, (Object)value));
                return true;
            }
            case "allowManualAcknowledgement": {
                ((PulsarComponent)((Object)component)).setAllowManualAcknowledgement((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pulsarMessageReceiptFactory": {
                ((PulsarComponent)((Object)component)).setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarMessageReceiptFactory.class, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((PulsarComponent)((Object)component)).setBasicPropertyBinding((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((PulsarComponent)((Object)component)).setLazyStartProducer((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((PulsarComponent)((Object)component)).setBridgeErrorHandler((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object component, String name, Object value) {
        switch (name.toLowerCase()) {
            case "autoconfiguration": {
                ((PulsarComponent)((Object)component)).setAutoConfiguration((AutoConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, AutoConfiguration.class, (Object)value));
                return true;
            }
            case "pulsarclient": {
                ((PulsarComponent)((Object)component)).setPulsarClient((PulsarClient)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarClient.class, (Object)value));
                return true;
            }
            case "allowmanualacknowledgement": {
                ((PulsarComponent)((Object)component)).setAllowManualAcknowledgement((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pulsarmessagereceiptfactory": {
                ((PulsarComponent)((Object)component)).setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarMessageReceiptFactory.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((PulsarComponent)((Object)component)).setBasicPropertyBinding((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((PulsarComponent)((Object)component)).setLazyStartProducer((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((PulsarComponent)((Object)component)).setBridgeErrorHandler((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

