/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PulsarPath {
    private static final Pattern PATTERN = Pattern.compile("^((persistent|non-persistent)://)?(?<namespace>(?<tenant>.+)/.+)/.+$");
    private String tenant;
    private String namespace;
    private boolean autoConfigurable;

    public PulsarPath(String path) {
        Matcher matcher = PATTERN.matcher(path);
        this.autoConfigurable = matcher.matches();
        if (this.autoConfigurable) {
            this.tenant = matcher.group("tenant");
            this.namespace = matcher.group("namespace");
        }
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isAutoConfigurable() {
        return this.autoConfigurable;
    }
}

