/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.java.PubNub;
import com.pubnub.api.java.callbacks.SubscribeCallback;
import com.pubnub.api.java.models.consumer.objects_api.channel.PNChannelMetadataResult;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNMembershipResult;
import com.pubnub.api.java.models.consumer.objects_api.uuid.PNUUIDMetadataResult;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubConsumer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubNubConfiguration;

    public PubNubConsumer(PubNubEndpoint endpoint, Processor processor, PubNubConfiguration pubNubConfiguration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.pubNubConfiguration = pubNubConfiguration;
    }

    private void initCommunication() {
        this.endpoint.getPubnub().addListener((SubscribeCallback)new PubNubCallback());
        if (this.pubNubConfiguration.isWithPresence()) {
            this.endpoint.getPubnub().subscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).withPresence().execute();
        } else {
            this.endpoint.getPubnub().subscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).execute();
        }
    }

    private void terminateCommunication() {
        try {
            this.endpoint.getPubnub().unsubscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.initCommunication();
    }

    protected void doResume() throws Exception {
        super.doResume();
        this.initCommunication();
    }

    protected void doStop() throws Exception {
        this.terminateCommunication();
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.terminateCommunication();
        super.doSuspend();
    }

    class PubNubCallback
    extends SubscribeCallback {
        PubNubCallback() {
        }

        public void status(PubNub pubnub, PNStatus status) {
            if (status.getCategory() == PNStatusCategory.PNUnexpectedDisconnectCategory || status.getCategory() == PNStatusCategory.PNConnectionError) {
                LOG.trace("Got status: {}. Reconnecting to PubNub", (Object)status);
                pubnub.reconnect();
            } else {
                LOG.trace("Status message: {}", (Object)status);
            }
        }

        public void message(PubNub pubnub, PNMessageResult message) {
            Exchange exchange = PubNubConsumer.this.createExchange(true);
            Message inmessage = exchange.getIn();
            inmessage.setBody((Object)message);
            inmessage.setHeader("CamelPubNubTimeToken", (Object)message.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", (Object)message.getChannel());
            inmessage.setHeader("CamelMessageTimestamp", (Object)message.getTimetoken());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", (Throwable)exchange.getException());
            }
        }

        public void presence(PubNub pubnub, PNPresenceEventResult presence) {
            Exchange exchange = PubNubConsumer.this.createExchange(true);
            Message inmessage = exchange.getIn();
            inmessage.setBody((Object)presence);
            inmessage.setHeader("CamelPubNubTimeToken", (Object)presence.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", (Object)presence.getChannel());
            inmessage.setHeader("CamelMessageTimestamp", (Object)presence.getTimetoken());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", (Throwable)e);
            }
        }

        public void signal(@NotNull PubNub pubnub, @NotNull PNSignalResult pnSignalResult) {
            LOG.trace("signal: {}.", (Object)pnSignalResult);
        }

        public void uuid(@NotNull PubNub pubnub, @NotNull PNUUIDMetadataResult pnUUIDMetadataResult) {
            LOG.trace("uuid: {}.", (Object)pnUUIDMetadataResult);
        }

        public void channel(@NotNull PubNub pubnub, @NotNull PNChannelMetadataResult pnChannelMetadataResult) {
            LOG.trace("channel: {}.", (Object)pnChannelMetadataResult);
        }

        public void membership(@NotNull PubNub pubnub, @NotNull PNMembershipResult pnMembershipResult) {
            LOG.trace("membership: {}.", (Object)pnMembershipResult);
        }

        public void messageAction(@NotNull PubNub pubnub, @NotNull PNMessageActionResult pnMessageActionResult) {
            LOG.trace("messageAction: {}.", (Object)pnMessageActionResult);
        }

        public void file(@NotNull PubNub pubnub, @NotNull PNFileEventResult pnFileEventResult) {
            LOG.trace("file: {}.", (Object)pnFileEventResult);
        }
    }
}

