/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.cookie;

import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
@Configurer(extended=true)
public class CookieConfiguration {
    public static final String DEFAULT_PATH = "/";
    public static final boolean DEFAULT_SECURE_FLAG = false;
    public static final boolean DEFAULT_HTTP_ONLY_FLAG = false;
    public static final CookieSameSite DEFAULT_SAME_SITE = CookieSameSite.LAX;
    @UriParam(defaultValue="/")
    private String cookiePath = "/";
    @UriParam
    private String cookieDomain;
    @UriParam
    private Long cookieMaxAge;
    @UriParam(defaultValue="false")
    private boolean cookieSecure = false;
    @UriParam(defaultValue="false")
    private boolean cookieHttpOnly = false;
    @UriParam(defaultValue="Lax")
    private CookieSameSite cookieSameSite = DEFAULT_SAME_SITE;

    public CookieConfiguration() {
    }

    public CookieConfiguration(String cookiePath, String cookieDomain, Long cookieMaxAge, boolean cookieSecure, boolean cookieHttpOnly, CookieSameSite cookieSameSite) {
        this.cookiePath = cookiePath;
        this.cookieDomain = cookieDomain;
        this.cookieMaxAge = cookieMaxAge;
        this.cookieSecure = cookieSecure;
        this.cookieHttpOnly = cookieHttpOnly;
        this.cookieSameSite = cookieSameSite;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieMaxAge(Long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public Long getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void setCookieSameSite(CookieSameSite cookieSameSite) {
        this.cookieSameSite = cookieSameSite;
    }

    public CookieSameSite getCookieSameSite() {
        return this.cookieSameSite;
    }

    public static enum CookieSameSite {
        STRICT("Strict"),
        LAX("Lax"),
        NONE("None");

        private final String value;

        private CookieSameSite(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private String path = "/";
        private String domain;
        private Long maxAge;
        private boolean secure = false;
        private boolean httpOnly = false;
        private CookieSameSite sameSite = DEFAULT_SAME_SITE;

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setMaxAge(Long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder setSameSite(CookieSameSite sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public CookieConfiguration build() {
            return new CookieConfiguration(this.path, this.domain, this.maxAge, this.secure, this.httpOnly, this.sameSite);
        }
    }
}

