/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Experimental;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.spi.UploadAttacher;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpConsumer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;

@Experimental
@JdkService(value="platform-http-engine")
public class VertxPlatformHttpEngine
extends ServiceSupport
implements PlatformHttpEngine {
    private List<Handler<RoutingContext>> handlers = Collections.emptyList();
    private UploadAttacher uploadAttacher;

    public List<Handler<RoutingContext>> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void setHandlers(List<Handler<RoutingContext>> handlers) {
        if (handlers != null) {
            this.handlers = new ArrayList<Handler<RoutingContext>>(handlers);
        }
    }

    public UploadAttacher getUploadAttacher() {
        return this.uploadAttacher;
    }

    public void setUploadAttacher(UploadAttacher uploadAttacher) {
        this.uploadAttacher = uploadAttacher;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public Consumer createConsumer(PlatformHttpEndpoint endpoint, Processor processor) {
        return new VertxPlatformHttpConsumer(endpoint, processor, this.handlers, this.uploadAttacher);
    }
}

