/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.MainHttpServerFactory;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="platform-http-server")
public class DefaultMainHttpServerFactory
implements CamelContextAware,
MainHttpServerFactory {
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Service newHttpServer(HttpServerConfigurationProperties configuration) {
        MainHttpServer server = new MainHttpServer();
        server.setCamelContext(this.camelContext);
        server.setHost(configuration.getHost());
        server.setPort(configuration.getPort());
        server.setPath(configuration.getPath());
        if (configuration.getMaxBodySize() != null) {
            server.setMaxBodySize(configuration.getMaxBodySize());
        }
        server.setUseGlobalSslContextParameters(configuration.isUseGlobalSslContextParameters());
        server.setDevConsoleEnabled(configuration.isDevConsoleEnabled());
        server.setHealthCheckEnabled(configuration.isHealthCheckEnabled());
        server.setUploadEnabled(configuration.isUploadEnabled());
        server.setUploadSourceDir(configuration.getUploadSourceDir());
        return server;
    }
}

