/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-main-helper", threadSafe=true)
public class UpdateMainHelper
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/")
    protected File propertiesDir;
    @Parameter(defaultValue="${project.basedir}/")
    protected File baseDir;

    public void execute() throws MojoExecutionException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-main");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No core/camel-main folder found, skipping execution");
            return;
        }
        try {
            File targetDir = new File(camelDir, "src/generated/resources/org/apache/camel/main");
            File source = new File(this.propertiesDir, "components.properties");
            File target = new File(targetDir, "components.properties");
            FileUtil.updateFile((Path)source.toPath(), (Path)target.toPath());
            source = new File(this.propertiesDir, "dataformats.properties");
            target = new File(targetDir, "dataformats.properties");
            FileUtil.updateFile((Path)source.toPath(), (Path)target.toPath());
            source = new File(this.propertiesDir, "languages.properties");
            target = new File(targetDir, "languages.properties");
            FileUtil.updateFile((Path)source.toPath(), (Path)target.toPath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error updating camel-main", e);
        }
    }
}

