/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="update-test-infra-metadata", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class UpdateTestInfraMetadataMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/")
    protected File propertiesDir;
    @Parameter(defaultValue="${project.basedir}/")
    protected File baseDir;

    @Inject
    protected UpdateTestInfraMetadataMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File testInfraAll = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"test-infra/camel-test-infra-all");
        if (testInfraAll == null) {
            this.getLog().debug((CharSequence)"No test-infra/camel-test-infra-all folder found, skipping execution");
            return;
        }
        File source = new File(testInfraAll, "src/generated/resources/META-INF/metadata.json");
        File target = new File(this.propertiesDir, "test-infra/metadata.json");
        try {
            FileUtil.updateFile((Path)source.toPath(), (Path)target.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error updating camel-catalog", (Exception)e);
        }
    }
}

