/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.opentracing.GetBaggageProcessor;
import org.apache.camel.opentracing.OpenTracingSpanAdapter;
import org.apache.camel.opentracing.OpenTracingTracer;
import org.apache.camel.opentracing.SetBaggageProcessor;
import org.apache.camel.opentracing.TagProcessor;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.SpanAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTracingTracingStrategy
implements InterceptStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTracingTracingStrategy.class);
    private static final String UNNAMED = "unnamed";
    private final OpenTracingTracer tracer;

    public OpenTracingTracingStrategy(OpenTracingTracer tracer) {
        this.tracer = tracer;
    }

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, NamedNode processorDefinition, Processor target, Processor nextTarget) throws Exception {
        if (!this.shouldTrace(processorDefinition)) {
            return new DelegateAsyncProcessor(target);
        }
        return new DelegateAsyncProcessor(exchange -> {
            boolean activateExchange;
            OpenTracingSpanAdapter spanWrapper = (OpenTracingSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            Span span = spanWrapper.getOpenTracingSpan();
            if (span == null) {
                target.process(exchange);
                return;
            }
            Span processorSpan = this.tracer.getTracer().buildSpan(OpenTracingTracingStrategy.getOperationName(processorDefinition)).asChildOf(span).withTag(Tags.COMPONENT.getKey(), OpenTracingTracingStrategy.getComponentName(processorDefinition)).start();
            boolean bl = activateExchange = !(target instanceof LogProcessor) && !(target instanceof TagProcessor) && !(target instanceof GetBaggageProcessor) && !(target instanceof SetBaggageProcessor);
            if (activateExchange) {
                ActiveSpanManager.activate((Exchange)exchange, (SpanAdapter)new OpenTracingSpanAdapter(processorSpan));
            }
            try (Scope scope = this.tracer.getTracer().scopeManager().activate(processorSpan, true);){
                target.process(exchange);
            }
            catch (Exception ex) {
                processorSpan.log(OpenTracingTracingStrategy.errorLogs(ex));
                throw ex;
            }
            finally {
                if (activateExchange) {
                    ActiveSpanManager.deactivate((Exchange)exchange);
                }
                processorSpan.finish();
            }
        });
    }

    private static String getComponentName(NamedNode processorDefinition) {
        return "camel-" + processorDefinition.getShortName();
    }

    private static String getOperationName(NamedNode processorDefinition) {
        String name = processorDefinition.getId();
        return name == null ? UNNAMED : name;
    }

    private static Map<String, Object> errorLogs(Throwable t) {
        HashMap<String, Object> logEvent = new HashMap<String, Object>(3);
        logEvent.put("event", Tags.ERROR.getKey());
        logEvent.put("error.kind", "Exception");
        logEvent.put("message", t.getMessage());
        return logEvent;
    }

    private boolean shouldTrace(NamedNode definition) {
        for (String pattern : this.tracer.getExcludePatterns()) {
            if (!PatternHelper.matchPattern((String)definition.getId(), (String)pattern)) continue;
            return false;
        }
        return true;
    }
}

