/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing;

import io.opentracing.Span;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.opentracing.OpenTracingSpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(TagProcessor.class);
    private String id;
    private String routeId;
    private final String tagName;
    private final Expression expression;

    public TagProcessor(String tagName, Expression expression) {
        this.tagName = tagName;
        this.expression = expression;
        ObjectHelper.notNull((Object)tagName, (String)"tagName");
        ObjectHelper.notNull((Object)expression, (String)"expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            OpenTracingSpanAdapter camelSpan = (OpenTracingSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (camelSpan != null) {
                Span span = camelSpan.getOpenTracingSpan();
                if (span != null) {
                    String tag = (String)this.expression.evaluate(exchange, String.class);
                    span.setTag(this.tagName, tag);
                } else {
                    LOG.warn("OpenTracing: cannot find managed span for exchange={}", (Object)exchange);
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "tag[" + this.tagName + ", " + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

