/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.SpanDecorator;
import org.apache.camel.opentracing.propagation.CamelHeadersExtractAdapter;
import org.apache.camel.opentracing.propagation.CamelHeadersInjectAdapter;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class AbstractSpanDecorator
implements SpanDecorator {
    @Override
    public boolean newSpan() {
        return true;
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return AbstractSpanDecorator.getComponentName(endpoint);
    }

    public static String stripSchemeAndOptions(Endpoint endpoint) {
        int start = endpoint.getEndpointUri().indexOf(58);
        ++start;
        while (endpoint.getEndpointUri().charAt(start) == '/') {
            ++start;
        }
        int end = endpoint.getEndpointUri().indexOf(63);
        return end == -1 ? endpoint.getEndpointUri().substring(start) : endpoint.getEndpointUri().substring(start, end);
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        String scheme = AbstractSpanDecorator.getComponentName(endpoint);
        span.setTag(Tags.COMPONENT.getKey(), "camel-" + scheme);
        span.setTag("camel.uri", URISupport.sanitizeUri((String)endpoint.getEndpointUri()));
    }

    @Override
    public void post(Span span, Exchange exchange, Endpoint endpoint) {
        if (exchange.isFailed()) {
            span.setTag(Tags.ERROR.getKey(), true);
            if (exchange.getException() != null) {
                HashMap<String, String> logEvent = new HashMap<String, String>();
                logEvent.put("event", "error");
                logEvent.put("error.kind", "Exception");
                logEvent.put("message", exchange.getException().getMessage());
                span.log(logEvent);
            }
        }
    }

    @Override
    public String getInitiatorSpanKind() {
        return "client";
    }

    @Override
    public String getReceiverSpanKind() {
        return "server";
    }

    public static Map<String, String> toQueryParameters(String uri) {
        int index = uri.indexOf(63);
        if (index != -1) {
            String queryString = uri.substring(index + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : queryString.split("&")) {
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static String getComponentName(Endpoint endpoint) {
        String[] splitURI = StringHelper.splitOnCharacter((String)endpoint.getEndpointUri(), (String)":", (int)2);
        if (splitURI.length > 0) {
            return splitURI[0];
        }
        return null;
    }

    @Override
    public TextMap getExtractAdapter(Map<String, Object> map, boolean encoding) {
        return new CamelHeadersExtractAdapter(map);
    }

    @Override
    public TextMap getInjectAdapter(Map<String, Object> map, boolean encoding) {
        return new CamelHeadersInjectAdapter(map);
    }
}

