/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.opentracing.ActiveSpanManager;
import org.apache.camel.opentracing.SpanDecorator;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="OpenTracingTracer")
public class OpenTracingTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTracingTracer.class);
    private static Map<String, SpanDecorator> decorators = new HashMap<String, SpanDecorator>();
    private final OpenTracingEventNotifier eventNotifier = new OpenTracingEventNotifier();
    private final OpenTracingLogListener logListener = new OpenTracingLogListener();
    private Tracer tracer;
    private CamelContext camelContext;
    private Set<String> excludePatterns = new HashSet<String>();
    private boolean encoding;

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
        this.init(camelContext);
        return new OpenTracingRoutePolicy(routeId);
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public boolean isEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    protected void doStart() throws Exception {
        Set tracers;
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        this.camelContext.addLogListener((LogListener)this.logListener);
        if (this.tracer == null && (tracers = this.camelContext.getRegistry().findByType(Tracer.class)).size() == 1) {
            this.tracer = (Tracer)tracers.iterator().next();
        }
        if (this.tracer == null) {
            this.tracer = TracerResolver.resolveTracer();
        }
        if (this.tracer == null) {
            this.tracer = NoopTracerFactory.create();
        }
        ServiceHelper.startServices((Object[])new Object[]{this.eventNotifier});
    }

    protected void doStop() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Object)((Object)this.eventNotifier));
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    protected SpanDecorator getSpanDecorator(Endpoint endpoint) {
        SpanDecorator sd = SpanDecorator.DEFAULT;
        String uri = endpoint.getEndpointUri();
        String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
        if (splitURI[1] != null) {
            String scheme = splitURI[0];
            sd = decorators.getOrDefault(scheme, sd);
        }
        return sd;
    }

    private boolean isExcluded(Exchange exchange, Endpoint endpoint) {
        String url = endpoint.getEndpointUri();
        if (url != null && !this.excludePatterns.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)pattern)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ServiceLoader.load(SpanDecorator.class).forEach(d -> {
            SpanDecorator existing = decorators.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                decorators.put(d.getComponent(), (SpanDecorator)d);
            }
        });
    }

    private final class OpenTracingLogListener
    implements LogListener {
        private OpenTracingLogListener() {
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            try {
                Span span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    fields.put("message", message);
                    span.log(fields);
                }
            }
            catch (Throwable t) {
                LOG.warn("OpenTracing: Failed to capture tracing data", t);
            }
            return message;
        }
    }

    private final class OpenTracingRoutePolicy
    extends RoutePolicySupport {
        OpenTracingRoutePolicy(String routeId) {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            try {
                if (OpenTracingTracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                SpanDecorator sd = OpenTracingTracer.this.getSpanDecorator(route.getEndpoint());
                Span span = OpenTracingTracer.this.tracer.buildSpan(sd.getOperationName(exchange, route.getEndpoint())).asChildOf(OpenTracingTracer.this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)sd.getExtractAdapter(exchange.getIn().getHeaders(), OpenTracingTracer.this.encoding))).withTag(Tags.SPAN_KIND.getKey(), sd.getReceiverSpanKind()).start();
                sd.pre(span, exchange, route.getEndpoint());
                ActiveSpanManager.activate(exchange, span);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("OpenTracing: start server span={}", (Object)span);
                }
            }
            catch (Throwable t) {
                LOG.warn("OpenTracing: Failed to capture tracing data", t);
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            try {
                if (OpenTracingTracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                Span span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("OpenTracing: finish server span={}", (Object)span);
                    }
                    SpanDecorator sd = OpenTracingTracer.this.getSpanDecorator(route.getEndpoint());
                    sd.post(span, exchange, route.getEndpoint());
                    span.finish();
                    ActiveSpanManager.deactivate(exchange);
                } else {
                    LOG.warn("OpenTracing: could not find managed span for exchange={}", (Object)exchange);
                }
            }
            catch (Throwable t) {
                LOG.warn("OpenTracing: Failed to capture tracing data", t);
            }
        }
    }

    private final class OpenTracingEventNotifier
    extends EventNotifierSupport {
        private OpenTracingEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            try {
                if (event instanceof ExchangeSendingEvent) {
                    ExchangeSendingEvent ese = (ExchangeSendingEvent)event;
                    SpanDecorator sd = OpenTracingTracer.this.getSpanDecorator(ese.getEndpoint());
                    if (!sd.newSpan() || OpenTracingTracer.this.isExcluded(ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    Span parent = ActiveSpanManager.getSpan(ese.getExchange());
                    Tracer.SpanBuilder spanBuilder = OpenTracingTracer.this.tracer.buildSpan(sd.getOperationName(ese.getExchange(), ese.getEndpoint())).withTag(Tags.SPAN_KIND.getKey(), sd.getInitiatorSpanKind());
                    if (parent != null) {
                        spanBuilder.asChildOf(parent);
                    }
                    Span span = spanBuilder.start();
                    sd.pre(span, ese.getExchange(), ese.getEndpoint());
                    OpenTracingTracer.this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)sd.getInjectAdapter(ese.getExchange().getIn().getHeaders(), OpenTracingTracer.this.encoding));
                    ActiveSpanManager.activate(ese.getExchange(), span);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("OpenTracing: start client span={}", (Object)span);
                    }
                } else if (event instanceof ExchangeSentEvent) {
                    ExchangeSentEvent ese = (ExchangeSentEvent)event;
                    SpanDecorator sd = OpenTracingTracer.this.getSpanDecorator(ese.getEndpoint());
                    if (!sd.newSpan() || OpenTracingTracer.this.isExcluded(ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    Span span = ActiveSpanManager.getSpan(ese.getExchange());
                    if (span != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("OpenTracing: start client span={}", (Object)span);
                        }
                        sd.post(span, ese.getExchange(), ese.getEndpoint());
                        span.finish();
                        ActiveSpanManager.deactivate(ese.getExchange());
                    } else {
                        LOG.warn("OpenTracing: could not find managed span for exchange={}", (Object)ese.getExchange());
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("OpenTracing: Failed to capture tracing data", t);
            }
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent;
        }

        public String toString() {
            return "OpenTracingEventNotifier";
        }
    }
}

