/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public abstract class AbstractMessagingSpanDecorator
extends AbstractSpanDecorator {
    public static final String MESSAGE_BUS_ID = "message_bus.id";

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getDestination(exchange, endpoint);
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag(Tags.MESSAGE_BUS_DESTINATION.getKey(), this.getDestination(exchange, endpoint));
        String messageId = this.getMessageId(exchange);
        if (messageId != null) {
            span.setTag(MESSAGE_BUS_ID, messageId);
        }
    }

    protected String getDestination(Exchange exchange, Endpoint endpoint) {
        return AbstractMessagingSpanDecorator.stripSchemeAndOptions(endpoint);
    }

    @Override
    public String getInitiatorSpanKind() {
        return "producer";
    }

    @Override
    public String getReceiverSpanKind() {
        return "consumer";
    }

    protected String getMessageId(Exchange exchange) {
        return null;
    }
}

