/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.OperationVisitor;
import org.apache.camel.util.ObjectHelper;

class PathVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;

    PathVisitor(String basePath, CodeEmitter<T> emitter, OperationFilter filter, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.destinationGenerator = destinationGenerator;
        if (ObjectHelper.isEmpty((String)basePath)) {
            emitter.emit("rest", new Object[0]);
        } else {
            emitter.emit("rest", basePath);
        }
    }

    void visit(String path, OpenApiPathItem definition) {
        OperationVisitor<T> restDslOperation = new OperationVisitor<T>(this.emitter, this.filter, path, this.destinationGenerator);
        PathVisitor.operationMapFrom(definition).forEach(restDslOperation::visit);
    }

    private static Map<HttpMethod, OpenApiOperation> operationMapFrom(OpenApiPathItem path) {
        LinkedHashMap<HttpMethod, OpenApiOperation> result = new LinkedHashMap<HttpMethod, OpenApiOperation>();
        if (path.getGet() != null) {
            result.put(HttpMethod.GET, path.getGet());
        }
        if (path.getPut() != null) {
            result.put(HttpMethod.PUT, path.getPut());
        }
        if (path.getPost() != null) {
            result.put(HttpMethod.POST, path.getPost());
        }
        if (path.getDelete() != null) {
            result.put(HttpMethod.DELETE, path.getDelete());
        }
        if (path.getPatch() != null) {
            result.put(HttpMethod.PATCH, path.getPatch());
        }
        if (path.getHead() != null) {
            result.put(HttpMethod.HEAD, path.getGet());
        }
        if (path.getOptions() != null) {
            result.put(HttpMethod.OPTIONS, path.getOptions());
        }
        return result;
    }

    public static enum HttpMethod {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        PATCH,
        POST,
        PUT;

    }
}

