/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.generator.openapi.RestDefinitionEmitter;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestDslXmlGenerator
extends RestDslGenerator<RestDslXmlGenerator> {
    private boolean blueprint;

    RestDslXmlGenerator(OpenApiDocument document) {
        super(document);
    }

    public String generate(CamelContext context) throws Exception {
        boolean restConfig;
        RestDefinitionEmitter emitter = new RestDefinitionEmitter();
        String basePath = RestDslGenerator.determineBasePathFrom(this.basePath, this.document);
        PathVisitor<RestsDefinition> restDslStatement = new PathVisitor<RestsDefinition>(basePath, emitter, this.filter, this.destinationGenerator());
        for (String name : this.document.getPaths().getItemNames()) {
            OpenApiPathItem item = (OpenApiPathItem)this.document.getPaths().getItem(name);
            restDslStatement.visit(name, item);
        }
        RestsDefinition rests = emitter.result();
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)context).dumpModelAsXml(context, (NamedNode)rests);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        if (this.blueprint) {
            document.renameNode(root, "http://camel.apache.org/schema/blueprint", root.getTagName());
        }
        NodeList elements = document.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            element.removeAttribute("customId");
        }
        boolean bl = restConfig = this.restComponent != null || this.restContextPath != null || this.clientRequestValidation;
        if (restConfig) {
            Element configuration = document.createElement("restConfiguration");
            if (ObjectHelper.isNotEmpty((String)this.restComponent)) {
                configuration.setAttribute("component", this.restComponent);
            }
            if (ObjectHelper.isNotEmpty((String)this.restContextPath)) {
                configuration.setAttribute("contextPath", this.restContextPath);
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                configuration.setAttribute("apiContextPath", this.apiContextPath);
            }
            if (this.clientRequestValidation) {
                configuration.setAttribute("clientRequestValidation", "true");
            }
            root.insertBefore(configuration, root.getFirstChild());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public RestDslXmlGenerator withBlueprint() {
        this.blueprint = true;
        return this;
    }
}

