/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Filer;
import org.apache.camel.generator.openapi.AppendableGenerator;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.DirectToOperationId;
import org.apache.camel.generator.openapi.FilerGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.PathGenerator;
import org.apache.camel.generator.openapi.RestDslDefinitionGenerator;
import org.apache.camel.generator.openapi.RestDslSourceCodeGenerator;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.util.ObjectHelper;

public abstract class RestDslGenerator<G> {
    String apiContextPath;
    DestinationGenerator destinationGenerator = new DirectToOperationId();
    final OasDocument document;
    OperationFilter filter = new OperationFilter();
    String restComponent;
    String restContextPath;
    boolean springBootProject;
    boolean springComponent;

    RestDslGenerator(OasDocument document) {
        this.document = (OasDocument)ObjectHelper.notNull((Object)document, (String)"document");
    }

    public G asSpringBootProject() {
        this.springBootProject = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G asSpringComponent() {
        this.springComponent = true;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withDestinationGenerator(DestinationGenerator directRouteGenerator) {
        ObjectHelper.notNull((Object)directRouteGenerator, (String)"directRouteGenerator");
        this.destinationGenerator = directRouteGenerator;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(OperationFilter filter) {
        this.filter = filter;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withOperationFilter(String include) {
        this.filter.setIncludes(include);
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestComponent(String restComponent) {
        this.restComponent = restComponent;
        RestDslGenerator that = this;
        return (G)that;
    }

    public G withRestContextPath(String contextPath) {
        this.restContextPath = contextPath;
        RestDslGenerator that = this;
        return (G)that;
    }

    DestinationGenerator destinationGenerator() {
        return this.destinationGenerator;
    }

    public static String determineBasePathFrom(OasDocument document) {
        Objects.requireNonNull(document, "document");
        if (document instanceof Oas20Document) {
            return ((Oas20Document)document).basePath;
        }
        if (document instanceof Oas30Document) {
            Oas30Document oas30Document = (Oas30Document)document;
            List servers = oas30Document.getServers();
            if (servers == null || servers.get(0) == null) {
                return "";
            }
            Oas30Server firstServer = (Oas30Server)servers.get(0);
            URI serverUrl = URI.create(RestDslGenerator.resolveVariablesIn(firstServer.url, firstServer));
            String basePath = serverUrl.getPath();
            if (basePath == null || basePath.length() == 0) {
                return "";
            }
            if (basePath.charAt(0) != '/') {
                basePath = "/" + basePath;
            }
            if (basePath.indexOf("//") == 0) {
                basePath = basePath.substring(1);
            }
            if ("/".equals(basePath)) {
                basePath = "";
            }
            return basePath;
        }
        throw new IllegalArgumentException("Unsupported document type: " + document.getClass().getName());
    }

    public static String determineHostFrom(OasDocument document) {
        if (document instanceof Oas20Document) {
            return ((Oas20Document)document).host;
        }
        if (document instanceof Oas30Document) {
            Oas30Document oas30Document = (Oas30Document)document;
            List servers = oas30Document.getServers();
            if (servers == null || servers.get(0) == null) {
                return "";
            }
            Oas30Server firstServer = (Oas30Server)servers.get(0);
            URI serverUrl = URI.create(RestDslGenerator.resolveVariablesIn(firstServer.url, firstServer));
            return serverUrl.getHost();
        }
        throw new IllegalArgumentException("Unsupported document type: " + document.getClass().getName());
    }

    public static String resolveVariablesIn(String url, Oas30Server server) {
        List variables = Objects.requireNonNull(server, "server").getServerVariables();
        String withoutPlaceholders = url;
        for (ServerVariable variable : variables) {
            String name = "{" + variable.getName() + "}";
            withoutPlaceholders = withoutPlaceholders.replace(name, variable.default_);
        }
        return withoutPlaceholders;
    }

    public static RestDslSourceCodeGenerator<Appendable> toAppendable(OasDocument document) {
        return new AppendableGenerator(document);
    }

    public static RestDslDefinitionGenerator toDefinition(OasDocument document) {
        return new RestDslDefinitionGenerator(document);
    }

    public static RestDslSourceCodeGenerator<Filer> toFiler(OasDocument document) {
        return new FilerGenerator(document);
    }

    public static RestDslSourceCodeGenerator<Path> toPath(OasDocument document) {
        return new PathGenerator(document);
    }

    public static RestDslXmlGenerator toXml(OasDocument document) {
        return new RestDslXmlGenerator(document);
    }
}

