/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.generator.openapi.OperationVisitor;
import org.apache.camel.util.ObjectHelper;

class PathVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;

    PathVisitor(String basePath, CodeEmitter<T> emitter, OperationFilter filter, DestinationGenerator destinationGenerator) {
        this.emitter = emitter;
        this.filter = filter;
        this.destinationGenerator = destinationGenerator;
        if (ObjectHelper.isEmpty((Object)basePath)) {
            emitter.emit("rest", new Object[0]);
        } else {
            emitter.emit("rest", basePath);
        }
    }

    void visit(OasPathItem definition) {
        OperationVisitor<T> restDslOperation = new OperationVisitor<T>(this.emitter, this.filter, definition.getPath(), this.destinationGenerator);
        PathVisitor.operationMapFrom(definition).forEach(restDslOperation::visit);
    }

    void visit(String path, OasPathItem definition) {
        OperationVisitor<T> restDslOperation = new OperationVisitor<T>(this.emitter, this.filter, path, this.destinationGenerator);
        PathVisitor.operationMapFrom(definition).forEach(restDslOperation::visit);
    }

    private static Map<HttpMethod, OasOperation> operationMapFrom(OasPathItem path) {
        LinkedHashMap<HttpMethod, OasOperation> result = new LinkedHashMap<HttpMethod, OasOperation>();
        if (path.get != null) {
            result.put(HttpMethod.GET, path.get);
        }
        if (path.put != null) {
            result.put(HttpMethod.PUT, path.put);
        }
        if (path.post != null) {
            result.put(HttpMethod.POST, path.post);
        }
        if (path.delete != null) {
            result.put(HttpMethod.DELETE, path.delete);
        }
        if (path.patch != null) {
            result.put(HttpMethod.PATCH, path.patch);
        }
        if (path.head != null) {
            result.put(HttpMethod.HEAD, path.head);
        }
        if (path.options != null) {
            result.put(HttpMethod.OPTIONS, path.options);
        }
        return result;
    }

    public static enum HttpMethod {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        PATCH,
        POST,
        PUT;

    }
}

