/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import com.squareup.javapoet.MethodSpec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.commons.lang3.ClassUtils;

class MethodBodySourceCodeEmitter
implements CodeEmitter<MethodSpec> {
    private final MethodSpec.Builder builder;
    private boolean first = true;
    private final Deque<Integer> indentIntentStack = new ArrayDeque<Integer>();
    private final Deque<Integer> indentStack = new ArrayDeque<Integer>();

    MethodBodySourceCodeEmitter(MethodSpec.Builder builder) {
        this.builder = builder;
        this.indentStack.push(0);
    }

    @Override
    public CodeEmitter<MethodSpec> emit(String method, Object ... args) {
        boolean hasArgs = args != null && args.length > 0;
        int indent = this.indentLevelOf(method);
        if (!this.first || indent == 0) {
            this.builder.addCode("\n", new Object[0]);
        }
        this.builder.addCode(String.join((CharSequence)"", Collections.nCopies(this.indentStack.peek(), "$<")), new Object[0]);
        this.builder.addCode(String.join((CharSequence)"", Collections.nCopies(indent, "$>")), new Object[0]);
        if (!this.first) {
            this.builder.addCode(".", new Object[0]);
        }
        this.indentStack.push(indent);
        if (hasArgs) {
            this.builder.addCode("$L(" + this.invocationLiteralsFor(args) + ")", MethodBodySourceCodeEmitter.extend(method, MethodBodySourceCodeEmitter.argumentsFor(args)));
        } else {
            this.builder.addCode("$L()", new Object[]{method});
        }
        this.first = false;
        return this;
    }

    public void endEmit() {
        this.builder.addCode(";\n", new Object[0]);
        this.first = true;
    }

    @Override
    public MethodSpec result() {
        this.builder.addCode(String.join((CharSequence)"", Collections.nCopies(this.indentStack.peek(), "$<")), new Object[0]);
        this.builder.addCode("\n", new Object[0]);
        return this.builder.build();
    }

    int indentLevelOf(String method) {
        switch (method) {
            case "rest": {
                return 0;
            }
            case "post": 
            case "get": 
            case "put": 
            case "patch": 
            case "delete": 
            case "head": 
            case "options": {
                return 1;
            }
            case "param": {
                this.indentIntentStack.push(3);
                return 2;
            }
            case "endParam": {
                this.indentIntentStack.pop();
                return 2;
            }
            case "route": {
                this.indentIntentStack.push(3);
                return 2;
            }
            case "endRest": {
                this.indentIntentStack.pop();
                return 2;
            }
        }
        if (this.indentIntentStack.isEmpty()) {
            return 2;
        }
        return this.indentIntentStack.peek();
    }

    String invocationLiteralsFor(Object[] args) {
        StringJoiner literals = new StringJoiner(",");
        for (Object arg : args) {
            if (ClassUtils.isPrimitiveOrWrapper(arg.getClass())) {
                literals.add("$L");
                continue;
            }
            if (arg instanceof String) {
                literals.add("$S");
                continue;
            }
            if (arg instanceof Enum) {
                literals.add("$T.$L");
                continue;
            }
            if (!(arg instanceof String[])) continue;
            literals.add("$S");
        }
        return literals.toString();
    }

    static Object[] argumentsFor(Object[] args) {
        ArrayList<Object> arguments = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            if (ClassUtils.isPrimitiveOrWrapper(arg.getClass())) {
                arguments.add(arg);
                continue;
            }
            if (arg instanceof String) {
                arguments.add(arg);
                continue;
            }
            if (arg instanceof Enum) {
                arguments.add(arg.getClass());
                arguments.add(arg);
                continue;
            }
            if (!(arg instanceof String[])) continue;
            arguments.add(Arrays.stream((String[])arg).collect(Collectors.joining(",")));
        }
        return arguments.toArray(new Object[arguments.size()]);
    }

    static Object[] extend(Object first, Object ... others) {
        if (others == null || others.length == 0) {
            return new Object[]{first};
        }
        Object[] ret = new Object[1 + others.length];
        ret[0] = first;
        System.arraycopy(others, 0, ret, 1, others.length);
        return ret;
    }
}

