/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.ClientCredentials;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClientCredentialsProcessor
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        OAuth oauth = this.findOAuth(context).orElseGet(() -> {
            OAuthFactory factory = OAuthFactory.lookupFactory(context);
            return factory.createOAuth();
        });
        OAuthSession session = oauth.getOrCreateSession(exchange);
        if (session.getUserProfile().isPresent()) {
            UserProfile userProfile = session.removeUserProfile().orElseThrow();
            try {
                userProfile = this.authenticateExistingUserProfile(oauth, userProfile);
                session.putUserProfile(userProfile);
                return;
            }
            catch (OAuthException ex) {
                this.log.error("Failed to authenticate: {}", (Object)userProfile.subject(), (Object)ex);
            }
        }
        String clientId = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.client-id");
        String clientSecret = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.client-secret");
        UserProfile userProfile = oauth.authenticate(new ClientCredentials().setClientSecret(clientSecret).setClientId(clientId));
        session.putUserProfile(userProfile);
        this.log.info("Authenticated {}", (Object)userProfile.subject());
        userProfile.logDetails();
        String accessToken = userProfile.accessToken().orElseThrow(() -> new OAuthException("No access_token"));
        msg.setHeader("Authorization", (Object)("Bearer " + accessToken));
    }
}

