/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.oauth.OAuthSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySession
implements OAuthSession {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String sessionId;
    private final Map<String, Object> values = new HashMap<String, Object>();

    public InMemorySession(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public <T> Optional<T> getValue(String key, Class<T> clazz) {
        return Optional.ofNullable(this.values.get(key));
    }

    @Override
    public <T> void putValue(String key, T value) {
        this.values.put(key, value);
    }

    @Override
    public <T> Optional<T> removeValue(String key) {
        Optional<Object> maybeValue = this.getValue(key, Object.class);
        this.values.remove(key);
        return maybeValue;
    }
}

