/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty4.codec.DelimiterBasedFrameDecoder;

public class DatagramPacketDelimiterDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private final DelimiterBasedFrameDecoder delegateDecoder;

    public DatagramPacketDelimiterDecoder(int maxFrameLength, ByteBuf[] delimiters) {
        this.delegateDecoder = new DelimiterBasedFrameDecoder(maxFrameLength, true, delimiters);
    }

    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            ByteBuf payload = (ByteBuf)msg.content();
            Object result = this.delegateDecoder.decode(ctx, payload);
            DefaultAddressedEnvelope addressEvelop = new DefaultAddressedEnvelope(result, msg.recipient(), msg.sender());
            out.add(addressEvelop);
        }
    }
}

