/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.netty4.TextLineDelimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyHelper {
    public static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final Logger LOG = LoggerFactory.getLogger(NettyHelper.class);

    private NettyHelper() {
    }

    public static String getTextlineBody(Object body, Exchange exchange, TextLineDelimiter delimiter, boolean autoAppendDelimiter) throws NoTypeConversionAvailableException {
        String s = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        if (autoAppendDelimiter) {
            if (TextLineDelimiter.LINE.equals((Object)delimiter)) {
                if (!s.endsWith("\n")) {
                    LOG.trace("Auto appending missing newline delimiter to body");
                    s = s + "\n";
                }
            } else if (!s.endsWith("\u0000")) {
                LOG.trace("Auto appending missing null delimiter to body");
                s = s + "\u0000";
            }
        }
        return s;
    }

    public static void writeBodyAsync(Logger log, Channel channel, SocketAddress remoteAddress, Object body, Exchange exchange, ChannelFutureListener listener) {
        ChannelFuture future;
        if (remoteAddress != null) {
            if (log.isDebugEnabled()) {
                log.debug("Channel: {} remote address: {} writing body: {}", new Object[]{channel, remoteAddress, body});
            }
            DefaultAddressedEnvelope ae = new DefaultAddressedEnvelope(body, (SocketAddress)((InetSocketAddress)remoteAddress));
            future = channel.writeAndFlush((Object)ae);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Channel: {} writing body: {}", new Object[]{channel, body});
            }
            future = channel.writeAndFlush(body);
        }
        if (listener != null) {
            future.addListener((GenericFutureListener)listener);
        }
    }

    public static void close(Channel channel) {
        if (channel != null) {
            LOG.trace("Closing channel: {}", (Object)channel);
            channel.close().syncUninterruptibly();
        }
    }
}

