/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.handlers;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.net.SocketAddress;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponseFutureListener
implements ChannelFutureListener {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private final NettyConsumer consumer;
    private final Exchange exchange;
    private final SocketAddress remoteAddress;

    public ServerResponseFutureListener(NettyConsumer consumer, Exchange exchange, SocketAddress remoteAddress) {
        this.consumer = consumer;
        this.exchange = exchange;
        this.remoteAddress = remoteAddress;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            CamelExchangeException e = new CamelExchangeException("Cannot write response to " + this.remoteAddress, this.exchange, future.cause());
            this.consumer.getExceptionHandler().handleException((Throwable)e);
        }
        Boolean close = this.exchange.hasOut() ? (Boolean)this.exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)this.exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
        boolean disconnect = this.consumer.getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Closing channel when complete at address: {}", (Object)this.remoteAddress);
            }
            NettyHelper.close(future.channel());
        }
    }
}

