/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.FullHttpResponse;
import java.io.InputStream;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty4.http.NettyHttpConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class NettyHttpConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        NettyHttpConverterLoader.addTypeConverter(registry, byte[].class, FullHttpResponse.class, false, (type, exchange, value) -> NettyHttpConverter.toBytes((FullHttpResponse)value, exchange));
        NettyHttpConverterLoader.addTypeConverter(registry, InputStream.class, FullHttpResponse.class, false, (type, exchange, value) -> NettyHttpConverter.toInputStream((FullHttpResponse)value, exchange));
        NettyHttpConverterLoader.addTypeConverter(registry, String.class, FullHttpResponse.class, false, (type, exchange, value) -> NettyHttpConverter.toString((FullHttpResponse)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        NettyHttpConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> NettyHttpConverter.convertToHttpRequest(type, exchange, value, registry));
        NettyHttpConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> NettyHttpConverter.convertToHttpResponse(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

