/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.NettyProducer;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpEndpoint;
import org.apache.camel.component.netty4.http.NettyHttpHelper;
import org.apache.camel.component.netty4.http.NettyHttpMessage;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class NettyHttpProducer
extends NettyProducer {
    public NettyHttpProducer(NettyHttpEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((NettyEndpoint)nettyEndpoint, configuration);
    }

    public NettyHttpEndpoint getEndpoint() {
        return (NettyHttpEndpoint)super.getEndpoint();
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return super.process(exchange, (AsyncCallback)new NettyHttpProducerCallback(exchange, callback, this.getConfiguration()));
    }

    protected Object getRequestBody(Exchange exchange) throws Exception {
        String uri = NettyHttpHelper.createURL(exchange, this.getEndpoint());
        URI u = NettyHttpHelper.createURI(exchange, uri, this.getEndpoint());
        HttpRequest request = this.getEndpoint().getNettyHttpBinding().toNettyRequest(exchange.getIn(), u.toString(), this.getConfiguration());
        String actualUri = request.uri();
        exchange.getIn().setHeader("CamelHttpUrl", (Object)actualUri);
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            exchange.setProperty("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        if (this.getConfiguration().isBridgeEndpoint()) {
            exchange.getIn().removeHeader("host");
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, new URI(actualUri));
            for (Map.Entry entry : cookieHeaders.entrySet()) {
                String key = (String)entry.getKey();
                if (((List)entry.getValue()).size() <= 0) continue;
                request.headers().add(key, (Iterable)entry.getValue());
            }
        }
        return request;
    }

    private final class NettyHttpProducerCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final NettyHttpConfiguration configuration;

        private NettyHttpProducerCallback(Exchange exchange, AsyncCallback callback, NettyHttpConfiguration configuration) {
            this.exchange = exchange;
            this.callback = callback;
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            try {
                if (!doneSync) {
                    FullHttpResponse response;
                    NettyHttpMessage nettyMessage;
                    NettyHttpMessage nettyHttpMessage = nettyMessage = this.exchange.hasOut() ? (NettyHttpMessage)((Object)this.exchange.getOut(NettyHttpMessage.class)) : (NettyHttpMessage)((Object)this.exchange.getIn(NettyHttpMessage.class));
                    if (nettyMessage != null && (response = nettyMessage.getHttpResponse()) != null) {
                        response.content().retain();
                        this.exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                if (response.refCnt() > 0) {
                                    NettyHttpProducer.this.log.debug("Releasing Netty HttpResonse ByteBuf");
                                    ReferenceCountUtil.release((Object)response);
                                }
                            }
                        });
                        String actualUrl = (String)this.exchange.getIn().getHeader("CamelHttpUrl", String.class);
                        int code = response.status() != null ? response.status().code() : -1;
                        NettyHttpProducer.this.log.debug("Http responseCode: {}", (Object)code);
                        boolean ok = NettyHttpHelper.isStatusCodeOk(code, this.configuration.getOkStatusCodeRange());
                        if (!ok && NettyHttpProducer.this.getConfiguration().isThrowExceptionOnFailure()) {
                            Exception cause = NettyHttpHelper.populateNettyHttpOperationFailedException(this.exchange, actualUrl, response, code, NettyHttpProducer.this.getConfiguration().isTransferException());
                            this.exchange.setException((Throwable)cause);
                        }
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

