/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import java.util.ArrayList;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.http.HttpClientInitializerFactory;
import org.apache.camel.component.netty4.http.HttpServerInitializerFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class NettyHttpConfiguration
extends NettyConfiguration {
    @UriPath(enums="http,https")
    @Metadata(required="true")
    private String protocol;
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath(name="port")
    private int dummy;
    @UriPath
    private String path;
    @UriParam(label="consumer,advanced")
    private boolean urlDecodeHeaders;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean mapHeaders = true;
    @UriParam(label="consumer,advanced")
    private boolean compression;
    @UriParam(label="producer", defaultValue="true")
    private boolean throwExceptionOnFailure = true;
    @UriParam(label="advanced")
    private boolean transferException;
    @UriParam(label="consumer")
    private boolean matchOnUriPrefix;
    @UriParam
    private boolean bridgeEndpoint;
    @UriParam(label="advanced")
    private boolean disableStreamCache;
    @UriParam(label="consumer", defaultValue="true")
    private boolean send503whenSuspended = true;
    @UriParam(label="consumer,advanced", defaultValue="1048576")
    private int chunkedMaxContentLength = 0x100000;
    @UriParam(label="consumer,advanced", defaultValue="8192")
    private int maxHeaderSize = 8192;
    @UriParam(label="producer,advanced", defaultValue="200-299")
    private String okStatusCodeRange = "200-299";
    @UriParam(label="producer,advanced")
    private boolean useRelativePath;

    public NettyHttpConfiguration() {
        this.setSync(true);
        this.setReuseAddress(true);
        this.setServerInitializerFactory(new HttpServerInitializerFactory());
        this.setClientInitializerFactory(new HttpClientInitializerFactory());
    }

    public NettyHttpConfiguration copy() {
        try {
            NettyHttpConfiguration answer = (NettyHttpConfiguration)((Object)((Object)((Object)this)).clone());
            ArrayList encodersCopy = new ArrayList(this.getEncoders());
            answer.setEncoders(encodersCopy);
            ArrayList decodersCopy = new ArrayList(this.getDecoders());
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return super.getHost();
    }

    public void setHost(String host) {
        super.setHost(host);
    }

    public int getPort() {
        return super.getPort();
    }

    public void setPort(int port) {
        super.setPort(port);
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isUrlDecodeHeaders() {
        return this.urlDecodeHeaders;
    }

    public void setUrlDecodeHeaders(boolean urlDecodeHeaders) {
        this.urlDecodeHeaders = urlDecodeHeaders;
    }

    public boolean isMapHeaders() {
        return this.mapHeaders;
    }

    public void setMapHeaders(boolean mapHeaders) {
        this.mapHeaders = mapHeaders;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disableStreamCache) {
        this.disableStreamCache = disableStreamCache;
    }

    public boolean isSend503whenSuspended() {
        return this.send503whenSuspended;
    }

    public void setSend503whenSuspended(boolean send503whenSuspended) {
        this.send503whenSuspended = send503whenSuspended;
    }

    public int getChunkedMaxContentLength() {
        return this.chunkedMaxContentLength;
    }

    public void setChunkedMaxContentLength(int chunkedMaxContentLength) {
        this.chunkedMaxContentLength = chunkedMaxContentLength;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public boolean isAllowDefaultCodec() {
        return false;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        throw new UnsupportedOperationException("You cannot setAllowDefaultCodec here.");
    }

    public String getOkStatusCodeRange() {
        return this.okStatusCodeRange;
    }

    public void setOkStatusCodeRange(String okStatusCodeRange) {
        this.okStatusCodeRange = okStatusCodeRange;
    }

    public void setUseRelativePath(boolean useRelativePath) {
        this.useRelativePath = useRelativePath;
    }

    public boolean isUseRelativePath() {
        return this.useRelativePath;
    }
}

