/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriParams
public class NettyServerBootstrapConfiguration
implements Cloneable {
    public static final String DEFAULT_ENABLED_PROTOCOLS = "TLSv1.2,TLSv1.3";
    @UriPath(enums="tcp,udp", description="The protocol to use which can be tcp or udp")
    @Metadata(required=true)
    protected String protocol;
    @UriPath
    @Metadata(required=true, description="The hostname. For the consumer the hostname is localhost or 0.0.0.0. For the producer the hostname is the remote host to connect to.")
    protected String host;
    @UriPath
    @Metadata(required=true, description="The host port number")
    protected int port;
    @UriParam(label="consumer,advanced", description="Setting to choose Multicast over UDP")
    protected boolean broadcast;
    @UriParam(label="advanced", defaultValue="65536", description="The TCP/UDP buffer sizes to be used during outbound communication. Size is bytes.")
    protected int sendBufferSize = 65536;
    @UriParam(label="advanced", defaultValue="65536", description="The TCP/UDP buffer sizes to be used during inbound communication. Size is bytes.")
    protected int receiveBufferSize = 65536;
    @UriParam(label="advanced", description="Configures the buffer size predictor. See details at Jetty documentation and this mail thread.")
    protected int receiveBufferSizePredictor;
    @UriParam(label="consumer,advanced", defaultValue="1", description="When netty works on nio mode, it uses default bossCount parameter from Netty, which is 1. User can use this option to override the default bossCount from Netty")
    protected int bossCount = 1;
    @UriParam(label="advanced", description="When netty works on nio mode, it uses default workerCount parameter from Netty (which is cpu_core_threads x 2). User can use this option to override the default workerCount from Netty.")
    protected int workerCount;
    @UriParam(defaultValue="true", description="Setting to ensure socket is not closed due to inactivity")
    protected boolean keepAlive = true;
    @UriParam(defaultValue="true", description="Setting to improve TCP protocol performance")
    protected boolean tcpNoDelay = true;
    @UriParam(defaultValue="true", description="Setting to facilitate socket multiplexing")
    protected boolean reuseAddress = true;
    @UriParam(label="producer", defaultValue="10000", description="Time to wait for a socket connection to be available. Value is in milliseconds.")
    protected int connectTimeout = 10000;
    @UriParam(label="consumer,advanced", description="Allows to configure a backlog for netty consumer (server). Note the backlog is just a best effort depending on the OS. Setting this option to a value such as 200, 500 or 1000, tells the TCP stack how long the \"accept\" queue can be If this option is not configured, then the backlog depends on OS setting.")
    protected int backlog;
    @UriParam(label="consumer,advanced", description="To use a custom ServerInitializerFactory")
    protected ServerInitializerFactory serverInitializerFactory;
    @UriParam(label="consumer,advanced", description="To use a custom NettyServerBootstrapFactory")
    protected NettyServerBootstrapFactory nettyServerBootstrapFactory;
    @UriParam(label="advanced", prefix="option.", multiValue=true, description="Allows to configure additional netty options using option. as prefix. For example option.child.keepAlive=false. See the Netty documentation for possible options that can be used.")
    protected Map<String, Object> options;
    @UriParam(label="security", description="Setting to specify whether SSL encryption is applied to this endpoint")
    protected boolean ssl;
    @UriParam(label="security", description="When enabled and in SSL mode, then the Netty consumer will enrich the Camel Message with headers having information about the client certificate such as subject name, issuer name, serial number, and the valid date range.")
    protected boolean sslClientCertHeaders;
    @UriParam(label="security", description="Reference to a class that could be used to return an SSL Handler")
    protected SslHandler sslHandler;
    @UriParam(label="security", description="To configure security using SSLContextParameters")
    protected SSLContextParameters sslContextParameters;
    @UriParam(label="consumer,security", description="Configures whether the server needs client authentication when using SSL.")
    protected boolean needClientAuth;
    @Deprecated
    @UriParam(label="security", description="Client side certificate keystore to be used for encryption")
    protected File keyStoreFile;
    @Deprecated
    @UriParam(label="security", description="Server side certificate keystore to be used for encryption")
    protected File trustStoreFile;
    @UriParam(label="security", description="Client side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.")
    @Metadata(supportFileReference=true)
    protected String keyStoreResource;
    @UriParam(label="security", description="Server side certificate keystore to be used for encryption. Is loaded by default from classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.")
    @Metadata(supportFileReference=true)
    protected String trustStoreResource;
    @UriParam(label="security", description="Keystore format to be used for payload encryption. Defaults to JKS if not set")
    protected String keyStoreFormat;
    @UriParam(label="security", description="Security provider to be used for payload encryption. Defaults to SunX509 if not set.")
    protected String securityProvider;
    @UriParam(defaultValue="TLSv1.2,TLSv1.3", label="security", description="Which protocols to enable when using SSL")
    protected String enabledProtocols = "TLSv1.2,TLSv1.3";
    @UriParam(label="security", secret=true, description="Password setting to use in order to encrypt/decrypt payloads sent using SSH")
    protected String passphrase;
    @UriParam(label="advanced", description="Whether to use native transport instead of NIO. Native transport takes advantage of the host operating system and is only supported on some platforms. You need to add the netty JAR for the host operating system you are using. See more details at: http://netty.io/wiki/native-transports.html")
    protected boolean nativeTransport;
    @UriParam(label="consumer,advanced", description="Set the BossGroup which could be used for handling the new connection of the server side across the NettyEndpoint")
    protected EventLoopGroup bossGroup;
    @UriParam(label="advanced", description="To use a explicit EventLoopGroup as the boss thread pool. For example to share a thread pool with multiple consumers or producers. By default each consumer or producer has their own worker pool with 2 x cpu count core threads.")
    protected EventLoopGroup workerGroup;
    @UriParam(label="advanced", description="To use an explicit ChannelGroup.")
    protected ChannelGroup channelGroup;
    @UriParam(label="consumer,advanced", description="When using UDP then this option can be used to specify a network interface by its name, such as eth0 to join a multicast group.")
    protected String networkInterface;
    @UriParam(label="consumer", defaultValue="true", description="Used only in clientMode in consumer, the consumer will attempt to reconnect on disconnection if this is enabled")
    private boolean reconnect = true;
    @UriParam(label="consumer", defaultValue="10000", description="Used if reconnect and clientMode is enabled. The interval in milli seconds to attempt reconnection")
    private int reconnectInterval = 10000;
    @UriParam(label="advanced", description="Path to unix domain socket to use instead of inet socket. Host and port parameters will not be used, however required. It is ok to set dummy values for them. Must be used with nativeTransport=true and clientMode=false.")
    private String unixDomainSocketPath;
    @UriParam(label="advanced", defaultValue="100", description="Shutdown await timeout in milliseconds")
    private int shutdownTimeout = 100;

    public String getAddress() {
        if (this.unixDomainSocketPath != null) {
            return this.unixDomainSocketPath;
        }
        return this.host + ":" + this.port;
    }

    public boolean isTcp() {
        return this.protocol.equalsIgnoreCase("tcp");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSizePredictor() {
        return this.receiveBufferSizePredictor;
    }

    public void setReceiveBufferSizePredictor(int receiveBufferSizePredictor) {
        this.receiveBufferSizePredictor = receiveBufferSizePredictor;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public int getBossCount() {
        return this.bossCount;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSslClientCertHeaders() {
        return this.sslClientCertHeaders;
    }

    public void setSslClientCertHeaders(boolean sslClientCertHeaders) {
        this.sslClientCertHeaders = sslClientCertHeaders;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @Deprecated
    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Deprecated
    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    @Deprecated
    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Deprecated
    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getKeyStoreResource() {
        return this.keyStoreResource;
    }

    public void setKeyStoreResource(String keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    public String getTrustStoreResource() {
        return this.trustStoreResource;
    }

    public void setTrustStoreResource(String trustStoreResource) {
        this.trustStoreResource = trustStoreResource;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Deprecated
    public ServerInitializerFactory getServerPipelineFactory() {
        return this.serverInitializerFactory;
    }

    @Deprecated
    public void setServerPipelineFactory(ServerInitializerFactory serverPipelineFactory) {
        this.serverInitializerFactory = serverPipelineFactory;
    }

    public ServerInitializerFactory getServerInitializerFactory() {
        return this.serverInitializerFactory;
    }

    public void setServerInitializerFactory(ServerInitializerFactory serverInitializerFactory) {
        this.serverInitializerFactory = serverInitializerFactory;
    }

    public NettyServerBootstrapFactory getNettyServerBootstrapFactory() {
        return this.nettyServerBootstrapFactory;
    }

    public void setNettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
        this.nettyServerBootstrapFactory = nettyServerBootstrapFactory;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isNativeTransport() {
        return this.nativeTransport;
    }

    public void setNativeTransport(boolean nativeTransport) {
        this.nativeTransport = nativeTransport;
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public void setChannelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public String getUnixDomainSocketPath() {
        return this.unixDomainSocketPath;
    }

    public void setUnixDomainSocketPath(String unixDomainSocketPath) {
        this.unixDomainSocketPath = unixDomainSocketPath;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public boolean compatible(NettyServerBootstrapConfiguration other) {
        boolean isCompatible = true;
        if (!this.protocol.equals(other.protocol)) {
            isCompatible = false;
        } else if (!this.host.equals(other.host)) {
            isCompatible = false;
        } else if (this.port != other.port) {
            isCompatible = false;
        } else if (this.broadcast != other.broadcast) {
            isCompatible = false;
        } else {
            if (this.sendBufferSize != other.sendBufferSize) {
                return false;
            }
            if (this.receiveBufferSize != other.receiveBufferSize) {
                isCompatible = false;
            } else if (this.receiveBufferSizePredictor != other.receiveBufferSizePredictor) {
                isCompatible = false;
            } else if (this.workerCount != other.workerCount) {
                isCompatible = false;
            } else if (this.bossCount != other.bossCount) {
                isCompatible = false;
            } else if (this.keepAlive != other.keepAlive) {
                isCompatible = false;
            } else if (this.tcpNoDelay != other.tcpNoDelay) {
                isCompatible = false;
            } else if (this.reuseAddress != other.reuseAddress) {
                isCompatible = false;
            } else if (this.connectTimeout != other.connectTimeout) {
                isCompatible = false;
            } else if (this.backlog != other.backlog) {
                isCompatible = false;
            } else if (this.serverInitializerFactory != other.serverInitializerFactory) {
                isCompatible = false;
            } else if (this.nettyServerBootstrapFactory != other.nettyServerBootstrapFactory) {
                isCompatible = false;
            } else if (this.options == null && other.options != null) {
                isCompatible = false;
            } else if (this.options != null && other.options == null) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && this.options.size() != other.options.size()) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && !this.options.keySet().containsAll(other.options.keySet())) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && !this.options.values().containsAll(other.options.values())) {
                isCompatible = false;
            } else if (this.ssl != other.ssl) {
                isCompatible = false;
            } else if (this.sslHandler != other.sslHandler) {
                isCompatible = false;
            } else if (this.sslContextParameters != other.sslContextParameters) {
                isCompatible = false;
            } else if (this.needClientAuth != other.needClientAuth) {
                isCompatible = false;
            } else if (this.keyStoreFile != other.keyStoreFile) {
                isCompatible = false;
            } else if (this.trustStoreFile != other.trustStoreFile) {
                isCompatible = false;
            } else if (this.keyStoreResource != null && !this.keyStoreResource.equals(other.keyStoreResource)) {
                isCompatible = false;
            } else if (this.trustStoreResource != null && !this.trustStoreResource.equals(other.trustStoreResource)) {
                isCompatible = false;
            } else if (this.keyStoreFormat != null && !this.keyStoreFormat.equals(other.keyStoreFormat)) {
                isCompatible = false;
            } else if (this.securityProvider != null && !this.securityProvider.equals(other.securityProvider)) {
                isCompatible = false;
            } else if (this.passphrase != null && !this.passphrase.equals(other.passphrase)) {
                isCompatible = false;
            } else if (this.bossGroup != other.bossGroup) {
                isCompatible = false;
            } else if (this.workerGroup != other.workerGroup) {
                isCompatible = false;
            } else if (this.networkInterface != null && !this.networkInterface.equals(other.networkInterface)) {
                isCompatible = false;
            } else if (this.reconnect != other.reconnect) {
                isCompatible = false;
            } else if (this.reconnectInterval != other.reconnectInterval) {
                isCompatible = false;
            } else if (!Objects.equals(this.unixDomainSocketPath, other.unixDomainSocketPath)) {
                isCompatible = false;
            }
        }
        return isCompatible;
    }

    public String toStringBootstrapConfiguration() {
        return "NettyServerBootstrapConfiguration{protocol='" + this.protocol + "', host='" + this.host + "', port=" + this.port + ", broadcast=" + this.broadcast + ", sendBufferSize=" + this.sendBufferSize + ", receiveBufferSize=" + this.receiveBufferSize + ", receiveBufferSizePredictor=" + this.receiveBufferSizePredictor + ", workerCount=" + this.workerCount + ", bossCount=" + this.bossCount + ", keepAlive=" + this.keepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", reuseAddress=" + this.reuseAddress + ", connectTimeout=" + this.connectTimeout + ", backlog=" + this.backlog + ", serverInitializerFactory=" + String.valueOf((Object)this.serverInitializerFactory) + ", nettyServerBootstrapFactory=" + String.valueOf(this.nettyServerBootstrapFactory) + ", options=" + String.valueOf(this.options) + ", ssl=" + this.ssl + ", sslHandler=" + String.valueOf(this.sslHandler) + ", sslContextParameters='" + String.valueOf(this.sslContextParameters) + "', needClientAuth=" + this.needClientAuth + ", enabledProtocols='" + this.enabledProtocols + ", keyStoreFile=" + String.valueOf(this.keyStoreFile) + ", trustStoreFile=" + String.valueOf(this.trustStoreFile) + ", keyStoreResource='" + this.keyStoreResource + "', trustStoreResource='" + this.trustStoreResource + "', keyStoreFormat='" + this.keyStoreFormat + "', securityProvider='" + this.securityProvider + "', passphrase='" + this.passphrase + "', bossGroup=" + String.valueOf(this.bossGroup) + ", workerGroup=" + String.valueOf(this.workerGroup) + ", networkInterface='" + this.networkInterface + "', reconnect='" + this.reconnect + "', reconnectInterval='" + this.reconnectInterval + "', unixDomainSocketPath='" + this.unixDomainSocketPath + "'}";
    }
}

