/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;

public final class NettyChannelBufferStreamCache
extends InputStream
implements StreamCache {
    private final ByteBuf buffer;

    public NettyChannelBufferStreamCache(ByteBuf buffer) {
        this.buffer = buffer.retain();
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.readerIndex() == this.buffer.capacity()) {
            return -1;
        }
        int before = this.buffer.readerIndex();
        int max = this.buffer.capacity() - before;
        len = Math.min(max, len);
        this.buffer.readBytes(b, off, len);
        return this.buffer.readerIndex() - before;
    }

    @Override
    public void reset() {
        this.buffer.resetReaderIndex();
    }

    public void writeTo(OutputStream os) throws IOException {
        int idx = this.buffer.readerIndex();
        try {
            this.buffer.resetReaderIndex();
            IOHelper.copy((InputStream)this, (OutputStream)os);
        }
        finally {
            this.buffer.readerIndex(idx);
        }
    }

    public StreamCache copy(Exchange exchange) throws IOException {
        return new NettyChannelBufferStreamCache(this.buffer.copy());
    }

    public boolean inMemory() {
        return true;
    }

    public long length() {
        return this.buffer.readableBytes();
    }

    public void release() {
        this.buffer.release();
    }
}

