/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.util.ArrayList;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.http.HttpClientPipelineFactory;
import org.apache.camel.component.netty.http.HttpServerPipelineFactory;

public class NettyHttpConfiguration
extends NettyConfiguration {
    private boolean urlDecodeHeaders;
    private boolean mapHeaders = true;
    private boolean compression;
    private boolean throwExceptionOnFailure = true;
    private boolean transferException;
    private boolean matchOnUriPrefix;
    private boolean bridgeEndpoint;
    private String path;
    private boolean disableStreamCache;
    private boolean send503whenSuspended = true;
    private int chunkedMaxContentLength = 0x100000;
    private boolean chunked = true;

    public NettyHttpConfiguration() {
        this.setSync(true);
        this.setReuseAddress(true);
        this.setServerPipelineFactory(new HttpServerPipelineFactory());
        this.setClientPipelineFactory(new HttpClientPipelineFactory());
    }

    public NettyHttpConfiguration copy() {
        try {
            NettyHttpConfiguration answer = (NettyHttpConfiguration)((Object)((Object)((Object)this)).clone());
            ArrayList encodersCopy = new ArrayList(this.getEncoders());
            answer.setEncoders(encodersCopy);
            ArrayList decodersCopy = new ArrayList(this.getDecoders());
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isUrlDecodeHeaders() {
        return this.urlDecodeHeaders;
    }

    public void setUrlDecodeHeaders(boolean urlDecodeHeaders) {
        this.urlDecodeHeaders = urlDecodeHeaders;
    }

    public boolean isMapHeaders() {
        return this.mapHeaders;
    }

    public void setMapHeaders(boolean mapHeaders) {
        this.mapHeaders = mapHeaders;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disableStreamCache) {
        this.disableStreamCache = disableStreamCache;
    }

    public boolean isSend503whenSuspended() {
        return this.send503whenSuspended;
    }

    public void setSend503whenSuspended(boolean send503whenSuspended) {
        this.send503whenSuspended = send503whenSuspended;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public int getChunkedMaxContentLength() {
        return this.chunkedMaxContentLength;
    }

    public void setChunkedMaxContentLength(int chunkedMaxContentLength) {
        this.chunkedMaxContentLength = chunkedMaxContentLength;
    }

    public boolean isAllowDefaultCodec() {
        return false;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        throw new UnsupportedOperationException("You cannot setAllowDefaultCodec here.");
    }
}

