/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerSharedPipelineFactory;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.component.netty.http.NettySharedHttpServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.handlers.HttpServerMultiplexChannelHandler;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettySharedHttpServer
extends ServiceSupport
implements NettySharedHttpServer {
    public static final String DEFAULT_PATTERN = "Camel Thread ##counter# - #name#:#port#";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettySharedHttpServer.class);
    private NettySharedHttpServerBootstrapConfiguration configuration;
    private HttpServerConsumerChannelFactory channelFactory;
    private HttpServerBootstrapFactory bootstrapFactory;
    private ClassResolver classResolver;
    private boolean startServer = true;
    private String threadPattern = "Camel Thread ##counter# - #name#:#port#";

    @Override
    public void setNettyServerBootstrapConfiguration(NettySharedHttpServerBootstrapConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public int getPort() {
        return this.configuration != null ? this.configuration.getPort() : -1;
    }

    @Override
    public HttpServerConsumerChannelFactory getConsumerChannelFactory() {
        return this.channelFactory;
    }

    @Override
    public NettyServerBootstrapFactory getServerBootstrapFactory() {
        return this.bootstrapFactory;
    }

    @Override
    public int getConsumersSize() {
        if (this.channelFactory != null) {
            return this.channelFactory.consumers();
        }
        return -1;
    }

    @Override
    public void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    @Override
    public void setThreadNamePattern(String pattern) {
        this.threadPattern = pattern;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.configuration), (String)"setNettyServerBootstrapConfiguration() must be called with a NettyServerBootstrapConfiguration instance", (Object)this);
        if (this.configuration.getPort() <= 0) {
            throw new IllegalArgumentException("Port must be configured on NettySharedHttpServerBootstrapConfiguration " + (Object)((Object)this.configuration));
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getHost())) {
            throw new IllegalArgumentException("Host must be configured on NettySharedHttpServerBootstrapConfiguration " + (Object)((Object)this.configuration));
        }
        LOG.debug("NettySharedHttpServer using configuration: {}", (Object)this.configuration);
        this.configuration.setProtocol("tcp");
        this.channelFactory = new HttpServerMultiplexChannelHandler();
        this.channelFactory.init(this.configuration.getPort());
        HttpServerSharedPipelineFactory pipelineFactory = new HttpServerSharedPipelineFactory(this.configuration, this.channelFactory, this.classResolver);
        String port = Matcher.quoteReplacement("" + this.configuration.getPort());
        String pattern = this.threadPattern;
        pattern = pattern.replaceFirst("#port#", port);
        CamelThreadFactory tf = new CamelThreadFactory(pattern, "NettySharedHttpServer", true);
        this.bootstrapFactory = new HttpServerBootstrapFactory(this.channelFactory, false);
        this.bootstrapFactory.init((ThreadFactory)tf, this.configuration, (ChannelPipelineFactory)pipelineFactory);
        ServiceHelper.startServices((Object[])new Object[]{this.channelFactory});
        if (this.startServer) {
            LOG.info("Starting NettySharedHttpServer on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ServiceHelper.startServices((Object[])new Object[]{this.bootstrapFactory});
        }
    }

    protected void doStop() throws Exception {
        LOG.info("Stopping NettySharedHttpServer on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        ServiceHelper.stopServices((Object[])new Object[]{this.bootstrapFactory, this.channelFactory});
    }
}

