/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.apache.camel.component.netty.http.handlers.HttpClientChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientPipelineFactory
extends ClientPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientPipelineFactory.class);
    private NettyHttpProducer producer;
    private SSLContext sslContext;

    public HttpClientPipelineFactory() {
    }

    public HttpClientPipelineFactory(NettyHttpProducer nettyProducer) {
        this.producer = nettyProducer;
        try {
            this.sslContext = this.createSSLContext(this.producer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    public ClientPipelineFactory createPipelineFactory(NettyProducer nettyProducer) {
        return new HttpClientPipelineFactory((NettyHttpProducer)nettyProducer);
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            sslHandler.setCloseOnSSLException(true);
            LOG.debug("Client SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("http", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("handler", (ChannelHandler)new HttpClientChannelHandler(this.producer));
        return pipeline;
    }

    private SSLContext createSSLContext(NettyProducer producer) throws Exception {
        SSLContext answer;
        NettyConfiguration configuration = producer.getConfiguration();
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext();
        } else {
            if (configuration.getKeyStoreFile() == null && configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (configuration.getTrustStoreFile() == null && configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(true);
            return new SslHandler(engine);
        }
        return null;
    }
}

