/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mustache.MustacheEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

public class MustacheComponent
extends DefaultComponent {
    private MustacheFactory mustacheFactory = new DefaultMustacheFactory();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String endDelimiter;
        String startDelimiter;
        MustacheEndpoint endpoint = new MustacheEndpoint(uri, (Component)this, remaining);
        endpoint.setMustacheFactory(this.getMustacheFactory());
        String encoding = (String)this.getAndRemoveParameter(parameters, "encoding", String.class);
        if (ObjectHelper.isNotEmpty((Object)encoding)) {
            endpoint.setEncoding(encoding);
        }
        if (ObjectHelper.isNotEmpty((Object)(startDelimiter = (String)this.getAndRemoveParameter(parameters, "startDelimiter", String.class)))) {
            endpoint.setStartDelimiter(startDelimiter);
        }
        if (ObjectHelper.isNotEmpty((Object)(endDelimiter = (String)this.getAndRemoveParameter(parameters, "endDelimiter", String.class)))) {
            endpoint.setEndDelimiter(endDelimiter);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public MustacheFactory getMustacheFactory() {
        return this.mustacheFactory;
    }

    public void setMustacheFactory(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }
}

