/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3.processor.idempotent;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoClient;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.bson.Document;
import org.bson.conversions.Bson;

@ManagedResource(description="Mongo db based message id repository")
public class MongoDbIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private MongoClient mongoClient;
    private String collectionName;
    private String dbName;
    private MongoCollection<Document> collection;

    public MongoDbIdempotentRepository() {
    }

    public MongoDbIdempotentRepository(MongoClient mongoClient, String collectionName, String dbName) {
        this.mongoClient = mongoClient;
        this.collectionName = collectionName;
        this.dbName = dbName;
        this.collection = mongoClient.getDatabase(dbName).getCollection(collectionName);
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        Document document = new Document("_id", (Object)key);
        try {
            this.collection.insertOne((Object)document);
        }
        catch (MongoWriteException ex) {
            if (ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                return false;
            }
            throw ex;
        }
        return true;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        Bson document = Filters.eq((String)"_id", (Object)key);
        long count = this.collection.count(document);
        return count > 0L;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        Bson document = Filters.eq((String)"_id", (Object)key);
        DeleteResult res = this.collection.deleteOne(document);
        return res.getDeletedCount() > 0L;
    }

    public boolean confirm(String key) {
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.collection.deleteMany((Bson)new Document());
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.mongoClient, (String)"cli");
        ObjectHelper.notNull((Object)this.dbName, (String)"dbName");
        ObjectHelper.notNull((Object)this.collectionName, (String)"collectionName");
        if (this.collection == null) {
            this.collection = this.mongoClient.getDatabase(this.dbName).getCollection(this.collectionName);
        }
    }

    protected void doStop() throws Exception {
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
}

