/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.gridfs;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mongodb.gridfs.GridFsConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class GridFsConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        GridFsConverterLoader.addTypeConverter(registry, ReadPreference.class, String.class, false, (type, exchange, value) -> GridFsConverter.toReadPreference((String)value, exchange));
        GridFsConverterLoader.addTypeConverter(registry, WriteConcern.class, String.class, false, (type, exchange, value) -> GridFsConverter.toWriteConcern((String)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

