/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milvus.transform;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import io.milvus.param.dml.InsertParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="milvus:embeddings", description="Prepares the message to become an object writable by Milvus component")
public class MilvusEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChainEmbeddingsVector", Embedding.class);
        String textFieldName = (String)message.getHeader("CamelMilvusTextFieldName", () -> "text", String.class);
        String vectorFieldName = (String)message.getHeader("CamelMilvusVectorFieldName", () -> "vector", String.class);
        String collectionName = (String)message.getHeader("CamelMilvusCollectionName", () -> "embeddings", String.class);
        TextSegment text = (TextSegment)message.getBody(TextSegment.class);
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        ArrayList<List> list = new ArrayList<List>();
        list.add(embedding.vectorAsList());
        fields.add(new InsertParam.Field(vectorFieldName, list));
        fields.add(new InsertParam.Field(textFieldName, Collections.singletonList(text.text())));
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(collectionName).withFields(fields).build();
        message.setBody((Object)insertParam);
    }
}

