/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milvus;

import io.milvus.client.MilvusClient;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.milvus.MilvusConfiguration;
import org.apache.camel.component.milvus.MilvusHeaders;
import org.apache.camel.component.milvus.MilvusProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.5.0", scheme="milvus", title="Milvus", syntax="milvus:collection", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=MilvusHeaders.class)
public class MilvusEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @Metadata(required=true)
    @UriPath(description="The collection Name")
    private final String collection;
    @UriParam
    private MilvusConfiguration configuration;
    private volatile boolean closeClient;
    private volatile MilvusClient client;

    public MilvusEndpoint(String endpointUri, Component component, String collection, MilvusConfiguration configuration) {
        super(endpointUri, component);
        this.collection = collection;
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "grpc";
    }

    public MilvusConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCollection() {
        return this.collection;
    }

    public MilvusClient getClient() {
        if (this.client == null) {
            this.lock.lock();
            try {
                if (this.client == null) {
                    this.client = this.configuration.getClient();
                    this.closeClient = false;
                    if (this.client == null) {
                        this.client = this.createClient();
                        this.closeClient = true;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.client;
    }

    public Producer createProducer() throws Exception {
        return new MilvusProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.client != null && this.closeClient) {
            this.client.close();
            this.client = null;
            this.closeClient = false;
        }
    }

    private MilvusClient createClient() {
        ConnectParam.Builder parameters = ConnectParam.newBuilder().withHost(this.configuration.getHost()).withPort(this.configuration.getPort()).withConnectTimeout(this.configuration.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.configuration.getToken() != null) {
            parameters.withToken(this.configuration.getToken());
        }
        return new MilvusServiceClient(parameters.build());
    }
}

